package tdd.adapters;



import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

import tdd.controllers.TestsuiteController;
import tdd.models.Testsuite;



public class CreateFinalStateTestActionAdapter implements ActionListener {

	
	
	private TestsuiteController testsuiteController;
	private Testsuite testsuite;
	
	
	
	public CreateFinalStateTestActionAdapter(TestsuiteController testsuiteController, Testsuite testsuite) {
	
		this.testsuiteController = testsuiteController;
		this.testsuite = testsuite;
	}
	
	
	
	@Override
	public void actionPerformed(ActionEvent e) {

		String name = JOptionPane.showInputDialog("Bitte Namen angeben");
		
		if(name != null) {
			
			if(name.length() == 0) {
				
				JOptionPane.showMessageDialog(null, "Der Name ist zu kurz");
				
			} else if(testsuite.existsTest(name)) {
				
				JOptionPane.showMessageDialog(null, "Der Test existiert bereits");
				
			} else {
				
				this.testsuiteController.createFinalStateTest(this.testsuite, name);
			}
		}
	}
}
