package tdd;



import java.io.File;

import tdd.controllers.TerritoryStateController;
import tdd.controllers.TestClassesController;
import tdd.controllers.TestRunner;
import tdd.controllers.TestsuiteController;
import tdd.interfaces.CompiledState;
import tdd.interfaces.ICompilerManager;
import tdd.interfaces.IProgramManager;
import tdd.interfaces.ISimulationManager;
import tdd.interfaces.IStateManager;
import tdd.interfaces.SimulationState;
import tdd.models.TerritoryStateContainer;
import tdd.models.TerritoryStates;
import tdd.models.TerritoryStatesDirectory;
import tdd.models.TestClassesDirectory;
import tdd.models.TestContentViewContainer;
import tdd.models.TestRunnerInformation;
import tdd.models.TestsuiteContainer;



public class TDDFramework {
	
	
	
	private TestsuiteContainer testsuiteContainer;
	private TestContentViewContainer testContentViewContainer;
	private TestRunnerInformation testRunnerInformation;
	private TestClassesDirectory testClassesDirectory;
	private TerritoryStates territoryStates;
	private TerritoryStateContainer territoryStateContainer;
	private TerritoryStatesDirectory territoryStatesDirectory;
	
	private TestsuiteController testsuiteController;
	private TestRunner testRunner;
	private TestClassesController testClassesController;
	private TerritoryStateController territoryStateController;
	
	
	
	public TDDFramework(
			ICompilerManager compilerManager, 
			IProgramManager programManager, 
			ISimulationManager simulationManager, 
			SimulationState simulationState,
			IStateManager stateManager,
			CompiledState compiledState) {
		
		this.testsuiteContainer = new TestsuiteContainer();
		this.testContentViewContainer = new TestContentViewContainer();
		this.testRunnerInformation = new TestRunnerInformation();
		this.testClassesDirectory = new TestClassesDirectory();
		this.territoryStates = new TerritoryStates();
		this.territoryStateContainer = new TerritoryStateContainer();
		this.territoryStatesDirectory = new TerritoryStatesDirectory();
		
		this.territoryStateController = new TerritoryStateController(
				stateManager, 
				this.territoryStateContainer, 
				this.getTerritoryStates(),
				this.territoryStatesDirectory			
			);
		
		this.testsuiteController = new TestsuiteController(
				compilerManager, 
				programManager,
				this.getTestsuiteContainer(),
				this.getTestClassesDirectory(), 
				this.getTestContentViewContainer(),
				this.getTerritoryStates(),
				this.getTerritoryStateController(),
				simulationState,
				compiledState
			);
		
		this.testRunner = new TestRunner(
				compilerManager,
				programManager,
				simulationManager,
				simulationState,
				stateManager,
				this.getTestsuiteContainer(), 
				this.getTestRunnerInformation(),
				this.getTestClassesDirectory(),
				this.getTerritoryStateController(),
				compiledState
			);
		
		this.testClassesController = new TestClassesController(
				this.getTestClassesDirectory(),
				programManager,
				compilerManager
			);
	}
	
	
	
	public TestsuiteContainer getTestsuiteContainer() {
		
		return this.testsuiteContainer;
	}
	
	public TestContentViewContainer getTestContentViewContainer() {
		
		return this.testContentViewContainer;
	}
	
	public TestRunnerInformation getTestRunnerInformation() {
		
		return this.testRunnerInformation;
	}
	
	public TestClassesDirectory getTestClassesDirectory() {
		
		return this.testClassesDirectory;
	}
	
	public TerritoryStates getTerritoryStates() {
		
		return this.territoryStates;
	}
	
	public TerritoryStateContainer getTerritoryStateContainer() {
		
		return this.territoryStateContainer;
	}
	
	public TestsuiteController getTestsuiteController() {
		
		return this.testsuiteController;
	}
	
	public TestRunner getTestRunner() {
		
		return this.testRunner;
	}
	
	public TestClassesController getTestClassesController() {
		
		return this.testClassesController;
	}
	
	public TerritoryStateController getTerritoryStateController() {
		
		return this.territoryStateController;
	}
	
	
	
	public boolean compile(String programClassName) {
		
		boolean compiled = this.getTestClassesController().compileTestClasses(programClassName);

		if(compiled) {
			
			return this.getTestsuiteController().compileTestsuite();
		}
		
		return false;
	}
	
	public void initialize(File testClassesDirectory, File rootTestsuiteDirectory, File territoryStateDirectory) {
		
		this.getTestClassesController().setTestClassesDirectory(testClassesDirectory);
		this.getTestsuiteController().initializeTestsuite(rootTestsuiteDirectory);
		this.getTerritoryStateController().setTerritoryStateDirectory(territoryStateDirectory);
	}
	
	public void save() {
		
		this.getTestsuiteController().saveTestsuite();
	}
	
	public void start() {
		
		this.getTestRunner().start();
	}
}
