package tdd;

import tdd.errors.AnzahlKoernerAufTerritoriumlGleichErwartungError;
import tdd.errors.AnzahlKoernerAufTerritoriumlUngleichErwartungError;
import tdd.errors.AnzahlKoernerAufKachelGleichErwartungError;
import tdd.errors.AnzahlKoernerAufKachelUngleichErwartungError;
import tdd.errors.AnzahlKoernerImMaulGleichErwartungError;
import tdd.errors.AnzahlKoernerImMaulUngleichErwartungError;
import tdd.errors.AnzahlKoernerInSpalteGleichErwartungError;
import tdd.errors.AnzahlKoernerInSpalteUngleichErwartungError;
import tdd.errors.AnzahlKoernerInReiheGleichErwartungError;
import tdd.errors.AnzahlKoernerInReiheUngleichErwartungError;
import tdd.errors.AnzahlSpaltenGleichErwartungError;
import tdd.errors.AnzahlSpaltenUngleichErwartungError;
import tdd.errors.AnzahlReihenGleichErwartungError;
import tdd.errors.AnzahlReihenUngleichErwartungError;
import tdd.errors.BlickrichtungErwartungError;
import tdd.errors.BlickrichtungNichtErwartungError;
import tdd.errors.GroeszeGleichErwartungError;
import tdd.errors.GroeszeUngleichErwartungError;
import tdd.errors.HamsterGleichErwartungError;
import tdd.errors.KeineKoernerAufTerritoriumErwartungError;
import tdd.errors.KeineKoernerAufKachelErwartungError;
import tdd.errors.KeineKoernerInSpalteErwartungError;
import tdd.errors.KeineKoernerInReiheErwartungError;
import tdd.errors.KeineMauerAufKachelErwartungError;
import tdd.errors.KornDaErwartungError;
import tdd.errors.KoernerAufTerritoriumErwartungError;
import tdd.errors.KoernerAufKachelErwartungError;
import tdd.errors.KoernerInSpalteErwartungError;
import tdd.errors.KoernerInReiheErwartungError;
import tdd.errors.MauerAufKachelErwartungError;
import tdd.errors.MaulLeerErwartungError;
import tdd.errors.NichtKornDaErwartungError;
import tdd.errors.NichtMaulLeerErwartungError;
import tdd.errors.NichtVornFreiErwartungError;
import tdd.errors.PositionGleichErwartungError;
import tdd.errors.PositionUngleichErwartungError;
import tdd.errors.SpalteGleichErwartungError;
import tdd.errors.SpalteUngleichErwartungError;
import tdd.errors.VornFreiErwartungError;
import tdd.errors.ReiheGleichErwartungError;
import tdd.errors.ReiheUngleichErwartungError;
import tdd.errors.TerritoriumGleichErwartungError;
import tdd.interfaces.IHamster;
import tdd.interfaces.ITerritory;

public class HamsterErwartungen extends Erwartungen {

	private static final String NORTH = "Norden";
	private static final String WEST = "Westen";
	private static final String SOUTH = "Süden";
	private static final String EAST = "Osten";

	protected HamsterErwartungen() {}

	// Hamster-Erwartungen
	public static void erwarteGleich(IHamster erwartet, IHamster ist) {

		erwarteGleich(null, erwartet, ist);
	}

	public static void erwarteGleich(String text, IHamster erwartet, IHamster ist) {

		try {

			erwartePositionGleich(ist, erwartet.getRow(), erwartet.getColumn());

		} catch (PositionGleichErwartungError e) {

			throw new HamsterGleichErwartungError(text, e);
		}

		try {

			erwarteAnzahlKoernerImMaulGleich(ist, erwartet.getNumberOfGrains());

		} catch (AnzahlKoernerImMaulGleichErwartungError e) {

			throw new HamsterGleichErwartungError(text, e);
		}

		try {

			if (erwartet.isDirectionNorth()) {

				erwarteBlickrichtungNord(ist);

			} else if (erwartet.isDirectionEast()) {

				erwarteBlickrichtungOst(ist);

			} else if (erwartet.isDirectionSouth()) {

				erwarteBlickrichtungSued(ist);

			} else if (erwartet.isDirectionSouth()) {

				erwarteBlickrichtungWest(ist);
			}

		} catch (BlickrichtungErwartungError e) {

			throw new HamsterGleichErwartungError(text, e);
		}
	}

	public static void erwarteReiheGleich(IHamster hamster, int reihe) {

		erwarteReiheGleich(null, hamster, reihe);
	}

	public static void erwarteReiheGleich(String text, IHamster hamster,
			int reihe) {

		if (hamster.getRow() != reihe)
			throw new ReiheGleichErwartungError(text, reihe, hamster.getRow());
	}

	public static void erwarteReiheUngleich(IHamster hamster, int reihe) {

		erwarteReiheUngleich(null, hamster, reihe);
	}

	public static void erwarteReiheUngleich(String text, IHamster hamster,
			int reihe) {

		if (hamster.getRow() == reihe)
			throw new ReiheUngleichErwartungError(text, reihe);
	}

	public static void erwarteSpalteGleich(IHamster hamster, int spalte) {

		erwarteSpalteGleich(null, hamster, spalte);
	}

	public static void erwarteSpalteGleich(String text, IHamster hamster, int spalte) {

		if (hamster.getColumn() != spalte)
			throw new SpalteGleichErwartungError(text, spalte,
					hamster.getColumn());
	}

	public static void erwarteSpalteUngleich(IHamster hamster, int spalte) {

		erwarteSpalteUngleich(null, hamster, spalte);
	}

	public static void erwarteSpalteUngleich(String text, IHamster hamster, int spalte) {

		if (hamster.getColumn() == spalte)
			throw new SpalteUngleichErwartungError(text, spalte);
	}

	public static void erwartePositionGleich(IHamster hamster, int reihe, int spalte) {

		erwartePositionGleich(null, hamster, reihe, spalte);
	}

	public static void erwartePositionGleich(String text, IHamster hamster, int reihe, int spalte) {

		try {

			erwarteReiheGleich(hamster, reihe);
			erwarteSpalteGleich(hamster, spalte);

		} catch (ReiheGleichErwartungError e) {

			throw new PositionGleichErwartungError(text, e);

		} catch (SpalteGleichErwartungError e) {

			throw new PositionGleichErwartungError(text, e);
		}
	}

	public static void erwartePositionUngleich(IHamster hamster, int reihe, int spalte) {

		erwartePositionUngleich(null, hamster, reihe, spalte);
	}

	public static void erwartePositionUngleich(String text, IHamster hamster, int reihe, int spalte) {

		if (hamster.getRow() == reihe && hamster.getColumn() == spalte)
			throw new PositionUngleichErwartungError(text, reihe, spalte);
	}

	public static void erwarteAnzahlKoernerImMaulGleich(IHamster hamster, int anzahl) {

		erwarteAnzahlKoernerImMaulGleich(null, hamster, anzahl);
	}

	public static void erwarteAnzahlKoernerImMaulGleich(String text, IHamster hamster, int anzahl) {

		if (hamster.getNumberOfGrains() != anzahl)
			throw new AnzahlKoernerImMaulGleichErwartungError(text, anzahl,
					hamster.getNumberOfGrains());
	}

	public static void erwarteAnzahlKoernerImMaulUngleich(IHamster hamster, int anzahl) {

		erwarteAnzahlKoernerImMaulUngleich(null, hamster, anzahl);
	}

	public static void erwarteAnzahlKoernerImMaulUngleich(String text, IHamster hamster, int anzahl) {

		if (hamster.getNumberOfGrains() == anzahl)
			throw new AnzahlKoernerImMaulUngleichErwartungError(text, anzahl);
	}

	public static void erwarteBlickrichtungNord(IHamster hamster) {

		erwarteBlickrichtungNord(null, hamster);
	}

	public static void erwarteBlickrichtungNord(String text, IHamster hamster) {

		if (!hamster.isDirectionNorth())
			throw new BlickrichtungErwartungError(NORTH, text);
	}

	public static void erwarteBlickrichtungNichtNord(IHamster hamster) {

		erwarteBlickrichtungNichtNord(null, hamster);
	}

	public static void erwarteBlickrichtungNichtNord(String text, IHamster hamster) {

		if (hamster.isDirectionNorth())
			throw new BlickrichtungNichtErwartungError(NORTH, text);
	}

	public static void erwarteBlickrichtungWest(IHamster hamster) {

		erwarteBlickrichtungWest(null, hamster);
	}

	public static void erwarteBlickrichtungWest(String text, IHamster hamster) {

		if (!hamster.isDirectionWest())
			throw new BlickrichtungErwartungError(WEST, text);
	}

	public static void erwarteBlickrichtungNichtWest(IHamster hamster) {

		erwarteBlickrichtungNichtWest(null, hamster);
	}

	public static void erwarteBlickrichtungNichtWest(String text, IHamster hamster) {

		if (hamster.isDirectionWest())
			throw new BlickrichtungNichtErwartungError(WEST, text);
	}

	public static void erwarteBlickrichtungSued(IHamster hamster) {

		erwarteBlickrichtungSued(null, hamster);
	}

	public static void erwarteBlickrichtungSued(String text, IHamster hamster) {

		if (!hamster.isDirectionSouth())
			throw new BlickrichtungErwartungError(SOUTH, text);
	}

	public static void erwarteBlickrichtungNichtSued(IHamster hamster) {

		erwarteBlickrichtungNichtSued(null, hamster);
	}

	public static void erwarteBlickrichtungNichtSued(String text, IHamster hamster) {

		if (hamster.isDirectionSouth())
			throw new BlickrichtungNichtErwartungError(SOUTH, text);
	}

	public static void erwarteBlickrichtungOst(IHamster hamster) {

		erwarteBlickrichtungOst(null, hamster);
	}

	public static void erwarteBlickrichtungOst(String text, IHamster hamster) {

		if (!hamster.isDirectionEast())
			throw new BlickrichtungErwartungError(EAST, text);
	}

	public static void erwarteBlickrichtungNichtOst(IHamster hamster) {

		erwarteBlickrichtungNichtOst(null, hamster);
	}

	public static void erwarteBlickrichtungNichtOst(String text, IHamster hamster) {

		if (hamster.isDirectionEast())
			throw new BlickrichtungNichtErwartungError(EAST, text);
	}

	public static void erwarteVornFrei(IHamster hamster) {

		erwarteVornFrei(null, hamster);
	}

	public static void erwarteVornFrei(String text, IHamster hamster) {

		if (!hamster.isAheadFree()) {

			throw new VornFreiErwartungError(text);
		}
	}

	public static void erwarteNichtVornFrei(IHamster hamster) {

		erwarteNichtVornFrei(null, hamster);
	}

	public static void erwarteNichtVornFrei(String text, IHamster hamster) {

		if (hamster.isAheadFree()) {

			throw new NichtVornFreiErwartungError(text);
		}
	}

	public static void erwarteKornDa(IHamster hamster) {

		erwarteKornDa(null, hamster);
	}

	public static void erwarteKornDa(String text, IHamster hamster) {

		if (!hamster.isGrainThere()) {

			throw new KornDaErwartungError(text);
		}
	}

	public static void erwarteNichtKornDa(IHamster hamster) {

		erwarteNichtKornDa(null, hamster);
	}

	public static void erwarteNichtKornDa(String text, IHamster hamster) {

		if (hamster.isGrainThere()) {

			throw new NichtKornDaErwartungError(text);
		}
	}

	public static void erwarteMaulLeer(IHamster hamster) {

		erwarteMaulLeer(null, hamster);
	}

	public static void erwarteMaulLeer(String text, IHamster hamster) {

		if (!hamster.isMouthEmpty()) {

			throw new MaulLeerErwartungError(text);
		}
	}

	public static void erwarteNichtMaulLeer(IHamster hamster) {

		erwarteNichtMaulLeer(null, hamster);
	}

	public static void erwarteNichtMaulLeer(String text, IHamster hamster) {

		if (hamster.isMouthEmpty()) {

			throw new NichtMaulLeerErwartungError(text);
		}
	}

	// Terretorium-Erwartungen
	public static void erwarteGleich(ITerritory erwartet, ITerritory ist) {

		erwarteGleich(null, erwartet, ist);
	}

	public static void erwarteGleich(String text, ITerritory erwartet, ITerritory ist) {

		try {

			erwarteGroeszeGleich(ist, erwartet.getNumberOfRows(),
					erwartet.getNumberOfColumns());

		} catch (GroeszeGleichErwartungError e) {

			throw new TerritoriumGleichErwartungError(text, e);
		}

		for (int i = 0; i < erwartet.getNumberOfRows(); i++) {

			for (int j = 0; j < erwartet.getNumberOfColumns(); j++) {

				try {

					erwarteAnzahlKoernerAufKachelGleich(ist, i, j,
							erwartet.getNumberOfGrainsOnTile(i, j));

				} catch (AnzahlKoernerAufKachelGleichErwartungError e) {

					throw new TerritoriumGleichErwartungError(text, e);
				}

				try {

					if (erwartet.isWallOnTile(i, j)) {

						erwarteMauerAufKachel(ist, i, j);
					}

				} catch (MauerAufKachelErwartungError e) {

					throw new TerritoriumGleichErwartungError(text, e);
				}
			}
		}

		try {

			erwarteGleich(erwartet.getHamsterState(), ist.getHamsterState());

		} catch (HamsterGleichErwartungError e) {

			throw new TerritoriumGleichErwartungError(text, e);
		}
	}

	public static void erwarteAnzahlReihenGleich(ITerritory territorium, int anzahl) {

		erwarteAnzahlReihenGleich(null, territorium, anzahl);
	}

	public static void erwarteAnzahlReihenGleich(String text, ITerritory territorium, int anzahl) {

		if (territorium.getNumberOfRows() != anzahl) {

			throw new AnzahlReihenGleichErwartungError(text, anzahl,
					territorium.getNumberOfRows());
		}
	}

	public static void erwarteAnzahlReihenUngleich(ITerritory territorium, int anzahl) {

		erwarteAnzahlReihenUngleich(null, territorium, anzahl);
	}

	public static void erwarteAnzahlReihenUngleich(String text, ITerritory territorium, int anzahl) {

		if (territorium.getNumberOfRows() == anzahl) {

			throw new AnzahlReihenUngleichErwartungError(text, anzahl);
		}
	}

	public static void erwarteAnzahlSpaltenGleich(ITerritory territorium, int anzahl) {

		erwarteAnzahlSpaltenGleich(null, territorium, anzahl);
	}

	public static void erwarteAnzahlSpaltenGleich(String text, ITerritory territorium, int anzahl) {

		if (territorium.getNumberOfColumns() != anzahl) {

			throw new AnzahlSpaltenGleichErwartungError(text, anzahl,
					territorium.getNumberOfColumns());
		}
	}

	public static void erwarteAnzahlSpaltenUngleich(ITerritory territorium,
			int anzahl) {

		erwarteAnzahlSpaltenUngleich(null, territorium, anzahl);
	}

	public static void erwarteAnzahlSpaltenUngleich(String text, ITerritory territorium, int anzahl) {

		if (territorium.getNumberOfColumns() == anzahl) {

			throw new AnzahlSpaltenUngleichErwartungError(text, anzahl);
		}
	}

	public static void erwarteGroeszeGleich(ITerritory territorium,
			int anzahlReihen, int anzahlSpalten) {

		erwarteGroeszeGleich(null, territorium, anzahlReihen, anzahlSpalten);
	}

	public static void erwarteGroeszeGleich(String text, ITerritory territorium, int anzahlReihen, int anzahlSpalten) {

		try {

			erwarteAnzahlReihenGleich(territorium, anzahlReihen);
			erwarteAnzahlSpaltenGleich(territorium, anzahlSpalten);

		} catch (AnzahlReihenGleichErwartungError e) {

			throw new GroeszeGleichErwartungError(text, e);

		} catch (AnzahlSpaltenGleichErwartungError e) {

			throw new GroeszeGleichErwartungError(text, e);
		}
	}

	public static void erwarteGroeszeUngleich(ITerritory territorium,
			int anzahlReihen, int anzahlSpalten) {

		erwarteGroeszeUngleich(null, territorium, anzahlReihen, anzahlSpalten);
	}

	public static void erwarteGroeszeUngleich(String text, ITerritory territorium, int anzahlReihen, int anzahlSpalten) {

		if (territorium.getNumberOfRows() == anzahlReihen
				&& territorium.getNumberOfColumns() == anzahlSpalten) {

			throw new GroeszeUngleichErwartungError(text, anzahlReihen,
					anzahlSpalten);
		}
	}

	public static void erwarteAnzahlKoernerAufKachelGleich(
			ITerritory territorium, int reihe, int spalte, int anzahl) {

		erwarteAnzahlKoernerAufKachelGleich(null, territorium, reihe, spalte,
				anzahl);
	}

	public static void erwarteAnzahlKoernerAufKachelGleich(String text, ITerritory territorium, int reihe, int spalte, int anzahl) {

		int grains = territorium.getNumberOfGrainsOnTile(reihe, spalte);

		if (grains != anzahl) {

			throw new AnzahlKoernerAufKachelGleichErwartungError(text, anzahl,
					grains, reihe, spalte);
		}
	}

	public static void erwarteAnzahlKoernerAufKachelUngleich(
			ITerritory territorium, int reihe, int spalte, int anzahl) {

		erwarteAnzahlKoernerAufKachelUngleich(null, territorium, reihe, spalte,
				anzahl);
	}

	public static void erwarteAnzahlKoernerAufKachelUngleich(String text, ITerritory territorium, int reihe, int spalte, int anzahl) {

		int grains = territorium.getNumberOfGrainsOnTile(reihe, spalte);

		if (grains == anzahl) {

			throw new AnzahlKoernerAufKachelUngleichErwartungError(text,
					grains, reihe, spalte);
		}
	}

	public static void erwarteKoernerAufKachel(ITerritory territorium,
			int reihe, int spalte) {

		erwarteKoernerAufKachel(null, territorium, reihe, spalte);
	}

	public static void erwarteKoernerAufKachel(String text, ITerritory territorium, int reihe, int spalte) {

		if (territorium.getNumberOfGrainsOnTile(reihe, spalte) == 0) {

			throw new KoernerAufKachelErwartungError(text, reihe, spalte);
		}
	}

	public static void erwarteKeineKoernerAufKachel(ITerritory territorium,
			int reihe, int spalte) {

		erwarteKeineKoernerAufKachel(null, territorium, reihe, spalte);
	}

	public static void erwarteKeineKoernerAufKachel(String text, ITerritory territorium, int reihe, int spalte) {

		if (territorium.getNumberOfGrainsOnTile(reihe, spalte) > 0) {

			throw new KeineKoernerAufKachelErwartungError(text, reihe, spalte);
		}
	}

	public static void erwarteAnzahlKoernerInReiheGleich(
			ITerritory territorium, int reihe, int anzahl) {

		erwarteAnzahlKoernerInReiheGleich(null, territorium, reihe, anzahl);
	}

	public static void erwarteAnzahlKoernerInReiheGleich(String text, ITerritory territorium, int reihe, int anzahl) {

		int grains = 0;

		for (int i = 0; i < territorium.getNumberOfColumns(); i++) {

			grains += territorium.getNumberOfGrainsOnTile(reihe, i);
		}

		if (grains != 0) {

			throw new AnzahlKoernerInReiheGleichErwartungError(text, anzahl,
					grains, reihe);
		}
	}

	public static void erwarteAnzahlKoernerInReiheUngleich(
			ITerritory territorium, int reihe, int anzahl) {

		erwarteAnzahlKoernerInReiheUngleich(null, territorium, reihe, anzahl);
	}

	public static void erwarteAnzahlKoernerInReiheUngleich(String text, ITerritory territorium, int reihe, int anzahl) {

		int grains = 0;

		for (int i = 0; i < territorium.getNumberOfColumns(); i++) {

			grains += territorium.getNumberOfGrainsOnTile(reihe, i);
		}

		if (grains != 0) {

			throw new AnzahlKoernerInReiheUngleichErwartungError(text, anzahl,
					reihe);
		}
	}

	public static void erwarteKoernerInReihe(ITerritory territorium, int reihe) {

		erwarteKoernerInReihe(null, territorium, reihe);
	}

	public static void erwarteKoernerInReihe(String text, ITerritory territorium, int reihe) {

		int grains = 0;

		for (int i = 0; i < territorium.getNumberOfColumns(); i++) {

			grains += territorium.getNumberOfGrainsOnTile(reihe, i);
		}

		if (grains == 0) {

			throw new KoernerInReiheErwartungError(text, reihe);
		}
	}

	public static void erwarteKeineKoernerInReihe(ITerritory territorium,
			int reihe) {

		erwarteKeineKoernerInReihe(null, territorium, reihe);
	}

	public static void erwarteKeineKoernerInReihe(String text, ITerritory territorium, int reihe) {

		int grains = 0;

		for (int i = 0; i < territorium.getNumberOfColumns(); i++) {

			grains += territorium.getNumberOfGrainsOnTile(reihe, i);
		}

		if (grains != 0) {

			throw new KeineKoernerInReiheErwartungError(text, reihe);
		}
	}

	public static void erwarteAnzahlKoernerInSpalteGleich(
			ITerritory territorium, int spalte, int anzahl) {

		erwarteAnzahlKoernerInSpalteGleich(null, territorium, spalte, anzahl);
	}

	public static void erwarteAnzahlKoernerInSpalteGleich(String text, ITerritory territorium, int spalte, int anzahl) {

		int grains = 0;

		for (int i = 0; i < territorium.getNumberOfRows(); i++) {

			grains += territorium.getNumberOfGrainsOnTile(i, spalte);
		}

		if (grains != anzahl) {

			throw new AnzahlKoernerInSpalteGleichErwartungError(text, anzahl,
					grains, spalte);
		}
	}

	public static void erwarteAnzahlKoernerInSpalteUngleich(
			ITerritory territorium, int spalte, int anzahl) {

		erwarteAnzahlKoernerInSpalteUngleich(null, territorium, spalte, anzahl);
	}

	public static void erwarteAnzahlKoernerInSpalteUngleich(String text, ITerritory territorium, int spalte, int anzahl) {

		int grains = 0;

		for (int i = 0; i < territorium.getNumberOfRows(); i++) {

			grains += territorium.getNumberOfGrainsOnTile(i, spalte);
		}

		if (grains == anzahl) {

			throw new AnzahlKoernerInSpalteUngleichErwartungError(text, anzahl,
					spalte);
		}
	}

	public static void erwarteKoernerInSpalte(ITerritory territorium, int spalte) {

		erwarteKoernerInSpalte(null, territorium, spalte);
	}

	public static void erwarteKoernerInSpalte(String text, ITerritory territorium, int spalte) {

		int grains = 0;

		for (int i = 0; i < territorium.getNumberOfRows(); i++) {

			grains += territorium.getNumberOfGrainsOnTile(i, spalte);
		}

		if (grains == 0) {

			throw new KoernerInSpalteErwartungError(text, spalte);
		}
	}

	public static void erwarteKeineKoernerInSpalte(ITerritory territorium,
			int spalte) {

		erwarteKeineKoernerInSpalte(null, territorium, spalte);
	}

	public static void erwarteKeineKoernerInSpalte(String text, ITerritory territorium, int spalte) {

		int grains = 0;

		for (int i = 0; i < territorium.getNumberOfRows(); i++) {

			grains += territorium.getNumberOfGrainsOnTile(i, spalte);
		}

		if (grains != 0) {

			throw new KeineKoernerInSpalteErwartungError(text, spalte);
		}
	}

	public static void erwarteAnzahlKoernerAufTerritoriumGleich(
			ITerritory territorium, int anzahl) {

		erwarteAnzahlKoernerAufTerritoriumGleich(null, territorium, anzahl);
	}

	public static void erwarteAnzahlKoernerAufTerritoriumGleich(String text, ITerritory territorium, int anzahl) {

		int grains = 0;

		for (int i = 0; i < territorium.getNumberOfRows(); i++) {

			for (int j = 0; j < territorium.getNumberOfColumns(); j++) {

				grains += territorium.getNumberOfGrainsOnTile(i, j);
			}
		}

		if (grains != anzahl) {

			throw new AnzahlKoernerAufTerritoriumlGleichErwartungError(text,
					anzahl, grains);
		}
	}

	public static void erwarteAnzahlKoernerAufTerritoriumUngleich(
			ITerritory territorium, int anzahl) {

		erwarteAnzahlKoernerAufTerritoriumUngleich(null, territorium, anzahl);
	}

	public static void erwarteAnzahlKoernerAufTerritoriumUngleich(String text, ITerritory territorium, int anzahl) {

		int grains = 0;

		for (int i = 0; i < territorium.getNumberOfRows(); i++) {

			for (int j = 0; j < territorium.getNumberOfColumns(); j++) {

				grains += territorium.getNumberOfGrainsOnTile(i, j);
			}
		}

		if (grains == anzahl) {

			throw new AnzahlKoernerAufTerritoriumlUngleichErwartungError(text,
					grains);
		}
	}

	public static void erwarteKoernerAufTerritorium(ITerritory territorium) {

		erwarteKoernerAufTerritorium(null, territorium);
	}

	public static void erwarteKoernerAufTerritorium(String text, ITerritory territorium) {

		boolean grainsOnField = false;

		for (int i = 0; i < territorium.getNumberOfRows(); i++) {

			for (int j = 0; j < territorium.getNumberOfColumns(); j++) {

				if (territorium.getNumberOfGrainsOnTile(i, j) > 0) {

					grainsOnField = true;

					break;
				}
			}

			if (grainsOnField)
				break;
		}

		if (!grainsOnField) {

			throw new KoernerAufTerritoriumErwartungError(text);
		}
	}

	public static void erwarteKeineKoernerAufTerritorium(ITerritory territorium) {

		erwarteKeineKoernerAufTerritorium(null, territorium);
	}

	public static void erwarteKeineKoernerAufTerritorium(String text, ITerritory territorium) {

		for (int i = 0; i < territorium.getNumberOfRows(); i++) {

			for (int j = 0; j < territorium.getNumberOfColumns(); j++) {

				if (territorium.getNumberOfGrainsOnTile(i, j) > 0) {

					throw new KeineKoernerAufTerritoriumErwartungError(text);
				}
			}
		}
	}

	public static void erwarteMauerAufKachel(ITerritory territorium, int reihe,
			int spalte) {

		erwarteMauerAufKachel(null, territorium, reihe, spalte);
	}

	public static void erwarteMauerAufKachel(String text, ITerritory territorium, int reihe, int spalte) {

		if (!territorium.isWallOnTile(reihe, spalte)) {

			throw new MauerAufKachelErwartungError(reihe, spalte, text);
		}
	}

	public static void erwarteKeineMauerAufKachel(ITerritory territorium,
			int reihe, int spalte) {

		erwarteKeineMauerAufKachel(null, territorium, reihe, spalte);
	}

	public static void erwarteKeineMauerAufKachel(String text, ITerritory territorium, int reihe, int spalte) {

		if (territorium.isWallOnTile(reihe, spalte)) {

			throw new KeineMauerAufKachelErwartungError(reihe, spalte, text);
		}
	}
}
