package tdd;



import java.util.Arrays;

import tdd.errors.FehlschlagError;
import tdd.errors.GleichErwartungError;
import tdd.errors.UngleichErwartungError;



public class Erwartungen {

	
	
	protected Erwartungen() {}
	
	
	
	public static void erwarteGleich(boolean[] erwartet, boolean[] ist)  {

		erwarteGleich(null, erwartet, ist);
	}

	public static void erwarteGleich(String text, boolean[] erwartet, boolean[] ist)  {

		if(!Arrays.equals(erwartet, ist)) throw new GleichErwartungError(erwartet, ist, text);
	}
	
	public static void erwarteGleich(char[] erwartet, char[] ist)  {

		erwarteGleich(null, erwartet, ist);
	}
	
	public static void erwarteGleich(String text, char[] erwartet, char[] ist)  {

		if(!Arrays.equals(erwartet, ist)) throw new GleichErwartungError(erwartet, ist, text);
	}

	public static void erwarteGleich(byte[] erwartet, byte[] ist)  {

		erwarteGleich(null, erwartet, ist);
	}
	
	public static void erwarteGleich(String text, byte[] erwartet, byte[] ist)  {

		if(!Arrays.equals(erwartet, ist)) throw new GleichErwartungError(erwartet, ist, text);
	}

	public static void erwarteGleich(short[] erwartet, short[] ist)  {

		erwarteGleich(null, erwartet, ist);
	}
	
	public static void erwarteGleich(String text, short[] erwartet, short[] ist)  {

		if(!Arrays.equals(erwartet, ist)) throw new GleichErwartungError(erwartet, ist, text);
	}
	
	public static void erwarteGleich(int[] erwartet, int[] ist)  {

		erwarteGleich(null, erwartet, ist);
	}
	
	public static void erwarteGleich(String text, int[] erwartet, int[] ist)  {

		if(!Arrays.equals(erwartet, ist)) throw new GleichErwartungError(erwartet, ist, text);
	}
	
	public static void erwarteGleich(long erwartet, long ist)  {
		
		erwarteGleich(null, erwartet, ist);
	}
	
	public static void erwarteGleich(String text, long erwartet, long ist)  {
		
		if(erwartet != ist) throw new GleichErwartungError(erwartet, ist, text);
	}
	
	public static void erwarteUngleich(long unerwartet, long ist)  {

		erwarteUngleich(null, unerwartet, ist);
	}
	
	public static void erwarteUngleich(String text, long unerwartet, long ist)  {

		if(unerwartet == ist) throw new UngleichErwartungError(unerwartet, ist, text);
	}
	
	public static void erwarteGleich(long[] erwartet, long[] ist)  {

		erwarteGleich(null, erwartet, ist);
	}
	
	public static void erwarteGleich(String text, long[] erwartet, long[] ist)  {

		if(!Arrays.equals(erwartet, ist)) throw new GleichErwartungError(erwartet, ist, text);
	}

	public static void erwarteWahr(boolean ist)  {

		erwarteWahr(null, ist);
	}
	
	public static void erwarteWahr(String text, boolean ist)  {

		if(!ist) throw new GleichErwartungError(true, ist, text);
	}
	
	public static void erwarteFalsch(boolean ist)  {
		
		erwarteFalsch(null, ist);
	}
	
	public static void erwarteFalsch(String text, boolean ist)  {
		
		if(ist) throw new GleichErwartungError(false, ist, text);
	}
	
	public static void erwarteFehlschlag() throws FehlschlagError {
		
		erwarteFehlschlag(null);
	}
	
	public static void erwarteFehlschlag(String text) throws FehlschlagError {
		
		throw new FehlschlagError(text);
	}
}
