/* The following code was generated by JFlex 1.4.1 on 3/24/13 12:59 AM */

/*
 * 03/24/2013
 *
 * VisualBasicTokenMaker.java - Scanner for Visual Basic
 *
 * This library is distributed under a modified BSD license.  See the included
 * RSyntaxTextArea.License.txt file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for Visual Basic.
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated <code>VisualBasicTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 1.0
 */

public class VisualBasicTokenMaker extends AbstractJFlexTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int EOL_COMMENT = 1;
  public static final int YYINITIAL = 0;

  /**
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED =
    "\11\0\1\11\1\10\1\0\1\11\1\5\22\0\1\64\1\37\1\12"+
    "\1\6\1\1\1\37\1\16\1\13\2\36\1\41\1\27\1\37\1\27"+
    "\1\30\1\44\1\3\11\3\1\47\1\37\1\42\1\40\1\43\1\37"+
    "\1\6\1\35\1\54\1\4\1\15\1\26\1\34\1\57\1\25\1\21"+
    "\1\60\1\63\1\22\1\61\1\52\1\53\1\46\1\1\1\14\1\24"+
    "\1\31\1\17\1\56\1\50\1\62\1\55\1\1\1\37\1\7\1\37"+
    "\1\45\1\2\1\0\1\35\1\54\1\4\1\51\1\26\1\33\1\57"+
    "\1\65\1\20\1\60\1\63\1\22\1\61\1\52\1\53\1\46\1\1"+
    "\1\32\1\23\1\31\1\17\1\56\1\66\1\62\1\55\1\1\3\5"+
    "\1\37\uff81\0";

  /**
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\2\0\1\1\1\2\1\3\2\2\1\4\1\5\1\6"+
    "\1\7\1\10\2\2\1\4\6\2\1\4\4\2\1\11"+
    "\1\4\13\2\1\12\1\13\6\12\1\14\1\3\2\14"+
    "\1\15\13\2\1\16\5\2\1\17\1\0\3\2\3\17"+
    "\47\2\1\17\14\2\1\12\2\0\3\12\2\0\1\15"+
    "\1\0\1\15\1\14\24\2\1\17\7\2\1\20\24\2"+
    "\1\17\2\2\1\17\11\2\1\17\13\2\1\17\12\2"+
    "\1\17\3\2\1\17\2\2\1\12\2\0\3\12\2\0"+
    "\2\2\1\21\14\2\1\20\1\14\16\2\1\22\17\2"+
    "\1\17\17\2\1\12\1\0\2\12\1\23\1\0\52\2"+
    "\1\0\1\12\1\0\1\2\1\24\21\2\1\17\6\2"+
    "\1\17\14\2\1\0\10\2\1\0\3\2\1\0\2\2"+
    "\6\0\1\17";

  private static int [] zzUnpackAction() {
    int [] result = new int[417];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\67\0\156\0\245\0\334\0\u0113\0\u014a\0\u0181"+
    "\0\u014a\0\u01b8\0\u01ef\0\u014a\0\u0226\0\u025d\0\u0294\0\u02cb"+
    "\0\u0302\0\u0339\0\u0370\0\u03a7\0\u03de\0\u0415\0\u044c\0\u0483"+
    "\0\u04ba\0\u04f1\0\u014a\0\u014a\0\u0528\0\u055f\0\u0596\0\u05cd"+
    "\0\u0604\0\u063b\0\u0672\0\u06a9\0\u06e0\0\u0717\0\u074e\0\u0785"+
    "\0\u014a\0\u07bc\0\u07f3\0\u082a\0\u0861\0\u0898\0\u08cf\0\u0906"+
    "\0\u0906\0\u093d\0\u0974\0\u09ab\0\u09e2\0\u0a19\0\u0a50\0\u0a87"+
    "\0\u0abe\0\u0af5\0\u0b2c\0\u0b63\0\u0b9a\0\u0bd1\0\u0c08\0\u014a"+
    "\0\u0c3f\0\u0c76\0\u0cad\0\u0ce4\0\u0d1b\0\u0d52\0\u0d89\0\u0dc0"+
    "\0\u0df7\0\u0e2e\0\u0e65\0\245\0\u0e9c\0\u0ed3\0\u0f0a\0\u0f41"+
    "\0\u0f78\0\u0faf\0\u0fe6\0\u101d\0\u1054\0\u108b\0\u10c2\0\u10f9"+
    "\0\u1130\0\u1167\0\u119e\0\u11d5\0\u120c\0\u1243\0\u127a\0\u12b1"+
    "\0\u12e8\0\u131f\0\u1356\0\u138d\0\u13c4\0\u13fb\0\u1432\0\u1469"+
    "\0\u14a0\0\u14d7\0\u150e\0\u1545\0\u157c\0\u15b3\0\u15ea\0\u1621"+
    "\0\u1658\0\u168f\0\u16c6\0\u16fd\0\u1734\0\u176b\0\u17a2\0\u17d9"+
    "\0\u1810\0\u1847\0\u187e\0\u18b5\0\u18ec\0\u1923\0\u195a\0\u1991"+
    "\0\u19c8\0\u19ff\0\u1a36\0\u1a6d\0\u1aa4\0\u1adb\0\u1b12\0\u1b49"+
    "\0\u1b80\0\u1bb7\0\u1bee\0\u0906\0\u1c25\0\u1c5c\0\u1c93\0\u1cca"+
    "\0\u1d01\0\u1d38\0\u1d6f\0\u1da6\0\u1ddd\0\u1e14\0\u1e4b\0\u1e82"+
    "\0\u1eb9\0\u1ef0\0\u1f27\0\u1f5e\0\u1f95\0\u1fcc\0\u2003\0\u203a"+
    "\0\u2071\0\u20a8\0\u20df\0\u2116\0\u214d\0\u2184\0\u21bb\0\u21f2"+
    "\0\u2229\0\u2260\0\u2297\0\u22ce\0\u2305\0\u233c\0\u2373\0\u23aa"+
    "\0\u23e1\0\u2418\0\u244f\0\u2486\0\u24bd\0\u24f4\0\u252b\0\u2562"+
    "\0\u2599\0\u25d0\0\u2607\0\u263e\0\u2675\0\u26ac\0\u26e3\0\u271a"+
    "\0\u2751\0\u2788\0\u27bf\0\u27f6\0\u282d\0\u2864\0\u289b\0\u28d2"+
    "\0\u2909\0\u2940\0\u2977\0\u29ae\0\u29e5\0\u2a1c\0\u2a53\0\u2a8a"+
    "\0\u2ac1\0\u2af8\0\u2b2f\0\u2b66\0\u2b9d\0\u2bd4\0\u2c0b\0\u2c42"+
    "\0\u2c79\0\u2cb0\0\u2ce7\0\u2d1e\0\u2d55\0\u2d8c\0\u2dc3\0\u2dfa"+
    "\0\u2e31\0\u2e68\0\u2e9f\0\u2ed6\0\u2f0d\0\u2f44\0\u2f7b\0\u2fb2"+
    "\0\u2fe9\0\u3020\0\u3057\0\u308e\0\u30c5\0\u30fc\0\u3133\0\u316a"+
    "\0\u31a1\0\u31d8\0\u320f\0\245\0\u3246\0\u327d\0\u32b4\0\u32eb"+
    "\0\u3322\0\u3359\0\u3390\0\u33c7\0\u33fe\0\u3435\0\u346c\0\u34a3"+
    "\0\u0906\0\u34da\0\u3511\0\u3548\0\u357f\0\u35b6\0\u35ed\0\u3624"+
    "\0\u365b\0\u3692\0\u36c9\0\u3700\0\u3737\0\u376e\0\u37a5\0\u37dc"+
    "\0\245\0\u3813\0\u384a\0\u3881\0\u38b8\0\u38ef\0\u3926\0\u395d"+
    "\0\u3994\0\u39cb\0\u3a02\0\u3a39\0\u3a70\0\u3aa7\0\u3ade\0\u3b15"+
    "\0\u3b4c\0\u3b83\0\u3bba\0\u3bf1\0\u3c28\0\u3c5f\0\u3c96\0\u3ccd"+
    "\0\u3d04\0\u3d3b\0\u3d72\0\u3da9\0\u3de0\0\u3e17\0\u3e4e\0\u3e85"+
    "\0\u3ebc\0\u3ef3\0\u3f2a\0\u3f61\0\u3f98\0\u3fcf\0\u4006\0\u403d"+
    "\0\u4074\0\u40ab\0\u40e2\0\u4119\0\u4150\0\u4187\0\u41be\0\u41f5"+
    "\0\u422c\0\u4263\0\u429a\0\u42d1\0\u4308\0\u433f\0\u4376\0\u43ad"+
    "\0\u43e4\0\u441b\0\u4452\0\u4489\0\u44c0\0\u44f7\0\u452e\0\u4565"+
    "\0\u459c\0\u45d3\0\u460a\0\u4641\0\u4678\0\u46af\0\u46e6\0\u471d"+
    "\0\u4754\0\u478b\0\u47c2\0\u47f9\0\u4830\0\u4867\0\u489e\0\u48d5"+
    "\0\u490c\0\u4943\0\u3f98\0\u497a\0\245\0\u49b1\0\u49e8\0\u2788"+
    "\0\u4a1f\0\u4a56\0\u4a8d\0\u4ac4\0\u4afb\0\u4b32\0\u4b69\0\u4ba0"+
    "\0\u4bd7\0\u4c0e\0\u4c45\0\u4c7c\0\u4cb3\0\u4cea\0\u2dfa\0\u4d21"+
    "\0\u4d58\0\u4d8f\0\u4dc6\0\u4dfd\0\u4e34\0\u4e6b\0\u4ea2\0\u4ed9"+
    "\0\u4f10\0\u4f47\0\u4f7e\0\u4fb5\0\u4fec\0\u5023\0\u505a\0\u5091"+
    "\0\u50c8\0\u50ff\0\u5136\0\u516d\0\u51a4\0\u51db\0\u5212\0\u5249"+
    "\0\u5280\0\u52b7\0\u52ee\0\u5325\0\u535c\0\u5393\0\u53ca\0\u5401"+
    "\0\u5438\0\u546f\0\u54a6\0\u54dd\0\u5514\0\u554b\0\u5582\0\u55b9"+
    "\0\u014a";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[417];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\3\2\4\1\5\1\6\1\7\1\3\1\10\1\11"+
    "\1\12\1\13\1\14\1\15\1\16\1\17\1\20\2\21"+
    "\1\22\2\23\1\24\1\25\1\26\1\27\1\30\1\15"+
    "\2\31\1\32\1\33\1\7\1\34\1\26\1\35\1\36"+
    "\2\26\1\37\1\7\1\40\1\16\1\41\1\42\1\43"+
    "\1\4\1\44\1\45\1\4\1\46\1\47\1\4\1\12"+
    "\1\24\1\40\10\50\1\51\14\50\1\52\5\50\1\53"+
    "\1\54\13\50\1\55\14\50\1\56\1\57\5\3\1\0"+
    "\2\3\4\0\2\3\1\0\10\3\2\0\5\3\10\0"+
    "\1\3\1\0\14\3\1\0\3\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\5\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\3\60\1\5\1\60\1\0"+
    "\2\60\4\0\3\61\1\62\1\60\1\61\2\60\1\61"+
    "\1\60\1\63\1\0\1\64\3\60\1\61\1\60\10\0"+
    "\1\60\1\0\14\60\1\0\2\60\1\3\3\4\1\65"+
    "\1\0\2\3\4\0\1\4\1\66\1\0\1\67\2\70"+
    "\1\71\2\72\1\73\1\4\2\0\1\74\3\4\1\75"+
    "\10\0\1\4\1\0\1\4\1\66\1\4\1\76\1\77"+
    "\7\4\1\0\1\73\1\4\67\0\5\3\1\0\2\3"+
    "\4\0\2\3\1\0\10\3\2\0\5\3\2\0\1\34"+
    "\5\0\1\3\1\0\14\3\1\0\2\3\11\0\1\12"+
    "\52\0\1\12\2\0\12\13\1\100\54\13\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\7\4\1\101\2\0"+
    "\4\4\1\102\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\1\4"+
    "\2\103\4\4\1\104\2\0\4\4\1\105\10\0\1\4"+
    "\1\0\3\4\1\106\10\4\1\0\2\4\25\0\1\107"+
    "\12\0\1\34\24\0\1\107\1\0\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\1\4\2\110\1\111\2\112"+
    "\2\4\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\4\4\2\113\2\4\2\0\2\4\2\114\1\4\10\0"+
    "\1\4\1\0\2\4\1\115\6\4\1\116\2\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\1\4\2\117\4\4\1\120\2\0\5\4\10\0\1\4"+
    "\1\0\3\4\1\121\10\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\1\122\2\123\3\4"+
    "\1\124\1\125\2\0\1\126\4\4\10\0\1\4\1\0"+
    "\4\4\1\127\1\130\6\4\1\0\1\124\1\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\10\4\2\0"+
    "\4\4\1\131\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\1\132\1\4\1\0"+
    "\3\4\1\133\4\4\2\0\1\4\1\132\2\4\1\134"+
    "\10\0\1\4\1\0\2\4\1\135\3\4\1\136\3\4"+
    "\1\137\1\4\1\0\2\4\40\0\1\34\31\0\1\64"+
    "\63\0\1\3\4\4\1\0\2\3\4\0\1\140\1\4"+
    "\1\0\6\4\1\141\1\4\2\0\1\4\1\140\3\4"+
    "\10\0\1\4\1\0\3\4\1\114\1\4\1\142\6\4"+
    "\1\0\1\141\1\4\1\3\4\4\1\0\2\3\4\0"+
    "\1\143\1\4\1\0\1\144\2\145\5\4\2\0\1\4"+
    "\1\143\2\4\1\146\10\0\1\4\1\0\3\4\1\147"+
    "\10\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\1\4\1\150\1\0\3\4\1\151\2\114\2\4\2\0"+
    "\5\4\10\0\1\4\1\0\1\4\1\150\1\152\11\4"+
    "\1\0\2\4\42\0\1\26\67\0\1\26\23\0\1\3"+
    "\4\4\1\0\2\3\4\0\1\153\1\4\1\0\1\154"+
    "\7\4\2\0\1\4\1\153\2\4\1\155\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\1\156\1\4\1\0\1\4\2\157\3\4\1\160"+
    "\1\161\2\0\1\4\1\156\3\4\10\0\1\4\1\0"+
    "\14\4\1\0\1\160\1\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\7\4\1\162\2\0\4\4\1\163"+
    "\10\0\1\4\1\0\3\4\1\164\10\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\1\165\1\4\1\0"+
    "\1\120\7\4\2\0\1\4\1\165\2\114\1\4\10\0"+
    "\1\166\1\0\2\4\1\114\1\4\1\167\1\4\1\170"+
    "\5\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\5\4\10\0\1\4\1\0"+
    "\3\4\1\171\1\4\1\172\6\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\10\4\2\0"+
    "\4\4\1\173\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\3\4"+
    "\1\174\3\4\1\175\2\0\5\4\10\0\1\4\1\0"+
    "\3\4\1\176\10\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\1\177\6\4\1\114\2\0"+
    "\5\4\10\0\1\4\1\0\3\4\1\200\1\4\1\201"+
    "\6\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\5\4\10\0\1\4\1\0"+
    "\3\4\1\147\10\4\1\0\2\4\10\50\1\0\22\50"+
    "\1\0\31\50\2\0\10\50\1\0\20\50\1\202\1\50"+
    "\1\0\31\50\22\0\2\203\7\0\1\204\35\0\10\50"+
    "\1\0\7\50\2\205\7\50\1\206\1\50\1\0\31\50"+
    "\2\0\10\50\1\0\22\50\1\0\14\50\1\207\14\50"+
    "\1\0\1\210\31\0\1\211\105\0\1\210\15\0\1\210"+
    "\5\60\1\0\2\60\4\0\2\60\1\0\10\60\2\0"+
    "\5\60\10\0\1\60\1\0\14\60\1\0\7\60\1\0"+
    "\2\60\4\0\2\60\1\0\1\60\5\61\2\60\2\0"+
    "\5\60\10\0\1\60\1\0\14\60\1\0\5\60\1\212"+
    "\1\60\1\0\2\60\4\0\2\60\1\0\10\60\1\213"+
    "\1\0\5\60\10\0\1\60\1\0\14\60\1\0\5\60"+
    "\1\64\1\60\1\0\2\60\4\0\3\214\1\215\1\60"+
    "\1\214\2\60\1\214\1\60\1\63\2\0\3\60\1\214"+
    "\1\60\10\0\1\60\1\0\14\60\1\0\2\60\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\6\4\1\216"+
    "\1\4\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\1\216\1\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\7\4\1\217\2\0\4\4\1\220\10\0\1\4"+
    "\1\0\4\4\1\221\7\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\1\4\2\70\1\222"+
    "\2\223\2\4\2\0\5\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\5\4\10\0\1\4\1\0\2\4"+
    "\1\120\11\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\4\4\1\224\10\0"+
    "\1\4\1\0\2\4\1\225\11\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\6\4\1\226"+
    "\1\4\2\0\1\147\4\4\10\0\1\4\1\0\2\4"+
    "\1\225\1\4\1\227\7\4\1\0\1\226\1\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\10\4\2\0"+
    "\4\4\1\230\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\10\4"+
    "\2\0\5\4\10\0\1\4\1\0\5\4\1\231\6\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\3\4\1\221\2\232\2\4\2\0\1\134\4\4"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\5\4"+
    "\10\0\1\4\1\0\2\4\1\233\1\4\1\234\7\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\5\4\10\0\1\4\1\0\3\4"+
    "\1\235\1\4\1\220\6\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\1\4\1\236\1\0\4\4\2\237"+
    "\2\4\2\0\1\240\3\4\1\241\10\0\1\4\1\0"+
    "\1\4\1\236\7\4\1\242\2\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\1\4\2\243"+
    "\5\4\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\1\244\1\4"+
    "\1\0\10\4\2\0\1\4\1\244\3\4\10\0\1\4"+
    "\1\0\11\4\1\114\2\4\1\0\2\4\1\3\3\4"+
    "\1\245\1\0\2\3\4\0\2\4\1\0\3\4\1\246"+
    "\4\4\2\0\2\4\2\247\1\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\1\250\4\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\1\251\7\4\2\0\5\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\3\0\2\252\10\0"+
    "\1\252\10\0\1\252\4\0\3\252\13\0\1\252\2\0"+
    "\1\252\12\0\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\5\4\10\0\1\4\1\0\2\4"+
    "\1\253\11\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\5\4\10\0\1\4"+
    "\1\0\3\4\1\254\10\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\1\4\2\222\3\4"+
    "\1\255\1\4\2\0\5\4\10\0\1\4\1\0\14\4"+
    "\1\0\1\255\1\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\5\4\10\0\1\4\1\0"+
    "\2\4\1\256\11\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\6\4\1\257\1\4\2\0"+
    "\1\260\4\4\10\0\1\4\1\0\14\4\1\0\1\257"+
    "\1\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\10\4\2\0\5\4\10\0\1\261\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\10\4\2\0\5\4\10\0\1\4\1\0\4\4\1\114"+
    "\6\4\1\232\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\1\114\4\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\10\4\2\0\5\4\10\0"+
    "\1\4\1\0\2\4\1\262\1\263\10\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\10\4"+
    "\2\0\5\4\10\0\1\4\1\0\4\4\1\114\7\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\5\4\10\0\1\4\1\0\2\4"+
    "\1\264\11\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\4\4\1\265\10\0"+
    "\1\4\1\0\3\4\1\266\10\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\3\4\1\267"+
    "\4\4\2\0\1\114\4\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\1\270"+
    "\1\4\1\0\7\4\1\263\2\0\1\4\1\270\2\4"+
    "\1\271\10\0\1\4\1\0\3\4\1\263\10\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\10\4\2\0\5\4\10\0\1\4\1\0\5\4\1\105"+
    "\6\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\5\4\10\0\1\4\1\0"+
    "\2\4\1\272\11\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\10\4\2\0\5\4\10\0"+
    "\1\4\1\0\2\4\1\273\11\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\1\47\1\4\1\0\10\4"+
    "\2\0\1\4\1\47\2\4\1\274\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\4\4\2\275\2\4\2\0\5\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\3\4\1\276"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\5\4"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\1\4\1\277\1\0\1\300\7\4"+
    "\2\0\5\4\10\0\1\4\1\0\1\4\1\277\12\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\7\4\1\70\2\0\5\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\1\4\2\120\5\4\2\0\5\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\1\301\7\4\2\0\5\4"+
    "\10\0\1\4\1\0\5\4\1\302\6\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\1\303\1\4\1\0"+
    "\7\4\1\304\2\0\1\4\1\303\3\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\5\4\10\0\1\305"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\1\4\2\306\5\4\2\0\5\4"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\5\4"+
    "\10\0\1\4\1\0\2\4\1\307\11\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\10\4"+
    "\2\0\5\4\10\0\1\4\1\0\2\4\1\310\11\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\3\4\1\311\4\4\2\0\5\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\1\114\1\4\1\0\10\4\2\0\1\4\1\114"+
    "\3\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\1\4\1\312\1\0\10\4"+
    "\2\0\5\4\10\0\1\4\1\0\1\4\1\312\12\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\1\4\2\313\5\4\2\0\5\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\1\4\1\314\1\0\10\4\2\0\5\4\10\0"+
    "\1\4\1\0\1\4\1\314\12\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\1\4\2\315"+
    "\5\4\2\0\5\4\10\0\1\4\1\0\3\4\1\316"+
    "\10\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\5\4\10\0\1\4\1\0"+
    "\4\4\1\317\7\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\1\320\1\4\1\0\10\4\2\0\1\4"+
    "\1\320\3\4\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\1\4"+
    "\2\321\5\4\2\0\5\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\1\4"+
    "\1\322\1\0\10\4\2\0\1\323\4\4\10\0\1\4"+
    "\1\0\1\4\1\322\12\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\1\4\2\324\4\4"+
    "\1\304\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\10\4\2\0\5\4\10\0\1\4\1\0\2\4\1\325"+
    "\11\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\5\4\10\0\1\4\1\0"+
    "\1\114\11\4\1\120\1\4\1\0\1\4\1\114\1\3"+
    "\4\4\1\0\2\3\4\0\1\326\1\4\1\0\10\4"+
    "\2\0\1\4\1\326\3\4\10\0\1\4\1\0\11\4"+
    "\1\327\2\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\1\330\4\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\7\4\1\331\2\0\5\4"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\7\4\1\332\2\0"+
    "\1\333\4\4\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\10\4"+
    "\2\0\5\4\10\0\1\4\1\0\10\4\1\334\3\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\7\4\1\335\2\0\5\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\5\4\10\0\1\4\1\0"+
    "\3\4\1\336\10\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\1\337\1\4\1\0\10\4\2\0\1\250"+
    "\1\337\3\4\10\0\1\4\1\0\6\4\1\340\5\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\1\341"+
    "\1\4\1\0\10\4\2\0\1\4\1\341\3\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\10\4\2\0\5\4\10\0"+
    "\1\4\1\0\3\4\1\342\10\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\10\4\2\0"+
    "\1\343\4\4\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\4\4"+
    "\2\344\2\4\2\0\1\345\4\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\4\4\2\346\2\4\2\0\5\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\1\4\1\347\1\0\10\4\2\0\5\4"+
    "\10\0\1\4\1\0\1\4\1\347\12\4\1\0\2\4"+
    "\1\3\3\4\1\350\1\0\2\3\4\0\2\4\1\0"+
    "\10\4\2\0\5\4\10\0\1\4\1\0\4\4\1\351"+
    "\7\4\1\0\2\4\10\50\1\0\20\50\1\352\1\50"+
    "\1\0\31\50\24\0\1\353\112\0\1\354\20\0\10\50"+
    "\1\0\11\50\1\355\10\50\1\0\31\50\2\0\10\50"+
    "\1\0\22\50\1\0\12\50\1\356\16\50\2\0\10\50"+
    "\1\0\22\50\1\0\14\50\1\357\14\50\1\0\1\360"+
    "\50\0\1\360\15\0\1\360\31\0\1\361\35\0\3\60"+
    "\1\212\1\60\1\0\2\60\4\0\3\214\1\215\1\60"+
    "\1\214\2\60\1\214\2\60\2\0\3\60\1\214\1\60"+
    "\10\0\1\60\1\0\14\60\1\0\2\60\3\0\1\212"+
    "\63\0\5\60\1\0\2\60\4\0\2\60\1\0\1\60"+
    "\5\214\2\60\2\0\5\60\10\0\1\60\1\0\14\60"+
    "\1\0\2\60\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\4\4\1\147\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\3\4\1\114\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\5\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\1\232\4\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\3\4\1\114\4\4\2\0"+
    "\5\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\10\4\2\0"+
    "\5\4\10\0\1\4\1\0\2\4\1\225\11\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\6\4\1\226\1\4\2\0\5\4\10\0\1\4\1\0"+
    "\14\4\1\0\1\226\1\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\4\4\2\362\2\4\2\0\5\4"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\5\4"+
    "\10\0\1\4\1\0\7\4\1\114\4\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\10\4"+
    "\2\0\5\4\10\0\1\4\1\0\3\4\1\363\10\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\5\4\10\0\1\4\1\0\5\4"+
    "\1\220\6\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\1\364\1\4\1\0\10\4\2\0\1\4\1\364"+
    "\3\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\10\4\2\0"+
    "\5\4\10\0\1\232\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\7\4\1\114"+
    "\2\0\5\4\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\4\4"+
    "\2\120\2\4\2\0\1\365\4\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\5\4\10\0\1\4\1\0"+
    "\10\4\1\114\3\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\10\4\2\0\5\4\10\0"+
    "\1\4\1\0\3\4\1\221\10\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\1\4\2\300"+
    "\5\4\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\1\366\7\4\2\0\5\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\1\367\7\4\2\0\5\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\1\4\1\370\1\0\10\4\2\0\5\4\10\0\1\4"+
    "\1\0\1\4\1\370\12\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\5\4"+
    "\10\0\1\4\1\0\3\4\1\371\10\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\4\4"+
    "\2\372\2\4\2\0\5\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\7\4\1\373\2\0\5\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\1\4\2\374\1\375\4\4\2\0\5\4"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\7\4\1\376\2\0"+
    "\5\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\10\4\2\0"+
    "\4\4\1\377\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\7\4"+
    "\1\364\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\10\4\2\0\5\4\10\0\1\4\1\0\4\4\1\u0100"+
    "\7\4\1\0\2\4\3\60\2\252\1\0\2\60\4\0"+
    "\1\u0101\1\252\1\u0101\1\u0102\1\60\1\u0101\2\60\1\u0101"+
    "\1\60\1\252\2\0\2\60\3\252\10\0\1\60\1\0"+
    "\1\60\1\252\2\60\1\252\7\60\1\0\2\60\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\10\4\2\0"+
    "\1\u0103\4\4\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\10\4"+
    "\2\0\5\4\10\0\1\4\1\0\2\4\1\262\11\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\5\4\10\0\1\4\1\0\3\4"+
    "\1\266\10\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\5\4\10\0\1\4"+
    "\1\0\3\4\1\120\10\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\7\4\1\u0104\2\0"+
    "\5\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\7\4\1\u0105"+
    "\2\0\5\4\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\3\4"+
    "\1\u0106\4\4\2\0\5\4\10\0\1\4\1\0\3\4"+
    "\1\u0107\10\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\5\4\10\0\1\4"+
    "\1\0\7\4\1\364\4\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\5\4"+
    "\10\0\1\114\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\5\4"+
    "\10\0\1\4\1\0\7\4\1\u0100\4\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\1\u0108\1\u0109\1\0"+
    "\10\4\2\0\1\4\1\u0108\3\4\10\0\1\4\1\0"+
    "\1\4\1\u0109\12\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\1\u010a\1\4\1\0\10\4\2\0\1\4"+
    "\1\u010a\3\4\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\7\4"+
    "\1\u010b\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\1\u010c\2\254\5\4\2\0\5\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\1\u010d\4\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\3\4\1\u010e\1\0"+
    "\2\3\4\0\2\4\1\0\10\4\2\0\5\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\1\4\1\u010f\1\0\10\4\2\0\5\4"+
    "\10\0\1\4\1\0\1\4\1\u010f\12\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\4\4"+
    "\2\232\2\4\2\0\5\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\7\4\1\277\2\0\5\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\6\4\1\114\1\4\2\0\5\4\10\0"+
    "\1\4\1\0\14\4\1\0\1\114\1\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\1\4\2\u0110\5\4"+
    "\2\0\5\4\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\10\4"+
    "\2\0\5\4\10\0\1\4\1\0\11\4\1\114\2\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\7\4\1\u0111\2\0\5\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\3\4\1\u0112\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\5\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\5\4\10\0\1\4"+
    "\1\0\3\4\1\u0113\10\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\5\4"+
    "\10\0\1\4\1\0\2\4\1\114\11\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\7\4"+
    "\1\u0114\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\7\4\1\161\2\0\5\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\3\4\1\u0115\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\5\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\4\4\1\u0116\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\4\4\2\301\2\4\2\0\5\4"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\1\u0117\1\4\1\0\6\4\1\u0118"+
    "\1\4\2\0\1\4\1\u0117\3\4\10\0\1\4\1\0"+
    "\14\4\1\0\1\u0118\1\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\4\4\1\362\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\10\4\2\0\4\4\1\u0119"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\5\4"+
    "\10\0\1\4\1\0\6\4\1\u011a\5\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\10\4"+
    "\2\0\1\u011b\4\4\10\0\1\u011c\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\3\4\1\u010d\4\4\2\0\5\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\1\u011d\3\4\1\u011e\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\10\4\2\0\1\u011f\4\4"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\7\4\1\u0120\2\0"+
    "\5\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\6\4\1\u0121"+
    "\1\4\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\1\u0121\1\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\3\4\1\232\4\4\2\0\5\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\1\4\1\114\1\0\10\4\2\0\5\4\10\0"+
    "\1\4\1\0\1\4\1\114\12\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\1\u0122\1\4\1\0\10\4"+
    "\2\0\1\4\1\u0122\3\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\7\4\1\u0123\2\0\5\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\1\4\2\u0124\3\4\1\u0125\1\4\2\0"+
    "\5\4\10\0\1\4\1\0\3\4\1\u0126\10\4\1\0"+
    "\1\u0125\1\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\3\4\1\274\4\4\2\0\5\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\1\u0127\1\4\1\0\10\4\2\0\1\4\1\u0127"+
    "\3\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\1\4\2\u0128"+
    "\5\4\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\7\4\1\u0129\2\0\5\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\1\u012a"+
    "\1\4\1\0\10\4\2\0\1\4\1\u012a\3\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\3\4\1\u012b\4\4\2\0"+
    "\5\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\7\4\1\u0110"+
    "\2\0\5\4\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\10\4"+
    "\2\0\4\4\1\221\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\1\4\2\u012c\5\4\2\0\5\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\5\4\10\0\1\4\1\0"+
    "\4\4\1\340\7\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\10\4\2\0\1\74\4\4"+
    "\10\0\1\4\1\0\12\4\1\u012d\1\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\1\122"+
    "\7\4\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\10\4\2\0\5\4\10\0\1\4\1\0\3\4\1\114"+
    "\10\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\1\u012e\4\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\1\u012f\7\4\2\0\5\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\3\4\1\u0130\4\4\2\0"+
    "\5\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\10\4\2\0"+
    "\4\4\1\274\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\10\50\1\0\22\50\1\0\12\50\1\u0131\16\50\30\0"+
    "\1\354\107\0\1\u0132\17\0\10\50\1\0\15\50\1\356"+
    "\4\50\1\0\31\50\2\0\10\50\1\0\22\50\1\0"+
    "\13\50\1\u0133\15\50\2\0\10\50\1\0\17\50\1\u0134"+
    "\2\50\1\0\31\50\32\0\1\u0135\104\0\1\u0136\20\0"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\4\4"+
    "\2\114\2\4\2\0\5\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\1\120"+
    "\1\4\1\0\10\4\2\0\1\4\1\120\3\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\1\4\2\u0137\5\4\2\0"+
    "\5\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\10\4\2\0"+
    "\5\4\10\0\1\4\1\0\11\4\1\232\2\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\1\u0138\1\4"+
    "\1\0\10\4\2\0\1\4\1\u0138\3\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\5\4\10\0\1\4"+
    "\1\0\3\4\1\u0139\10\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\5\4"+
    "\10\0\1\4\1\0\6\4\1\u013a\5\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\7\4"+
    "\1\u013b\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\1\3\3\4\1\u013c\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\5\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\5\4\10\0\1\4\1\0\11\4"+
    "\1\u013d\2\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\4\4\1\u013e\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\10\4\2\0\5\4\10\0"+
    "\1\4\1\0\7\4\1\u011a\4\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\1\u013f\7\4"+
    "\2\0\5\4\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\3\4"+
    "\1\250\4\4\2\0\5\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\5\60\1\0\2\60\4\0\2\60\1\0"+
    "\1\60\5\u0101\2\60\2\0\5\60\10\0\1\60\1\0"+
    "\14\60\1\0\2\60\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\7\4\1\u0140\2\0\5\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\1\u0141\1\4\1\0\10\4\2\0\1\4\1\u0141"+
    "\3\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\1\u0142\1\4\1\0\10\4"+
    "\2\0\1\4\1\u0142\3\4\10\0\1\4\1\0\7\4"+
    "\1\u0143\4\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\7\4\1\u0144\2\0\5\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\1\u0145\1\4\1\0\10\4\2\0\1\4"+
    "\1\u0145\3\4\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\7\4"+
    "\1\325\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\10\4\2\0\5\4\10\0\1\4\1\0\3\4\1\u0146"+
    "\10\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\1\364\4\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\3\4\1\120\1\0"+
    "\2\3\4\0\2\4\1\0\10\4\2\0\5\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\3\4\1\u0147"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\5\4"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\1\4\2\217\5\4"+
    "\2\0\5\4\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\3\4"+
    "\1\u0148\4\4\2\0\5\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\3\4\1\u0149\4\4\2\0\5\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\2\4\2\114\1\4"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\4\4"+
    "\1\u014a\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\10\4\2\0"+
    "\5\4\10\0\1\4\1\0\1\114\13\4\1\0\1\4"+
    "\1\114\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\10\4\2\0\5\4\10\0\1\4\1\0\3\4\1\u0110"+
    "\10\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\1\u014b\4\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\3\4\1\u014c\4\4\2\0\5\4"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\7\4\1\u014d\2\0"+
    "\5\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\10\4\2\0"+
    "\4\4\1\u014e\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\3\4"+
    "\1\u014f\4\4\2\0\5\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\4\4\1\220\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\7\4\1\u0150\2\0\5\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\7\4\1\u0151\2\0\5\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\1\4\2\340\5\4\2\0"+
    "\5\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\10\4\2\0"+
    "\5\4\10\0\1\4\1\0\11\4\1\u0152\2\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\7\4\1\370\2\0\5\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\5\4\10\0\1\4\1\0\2\4"+
    "\1\u0125\11\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\7\4\1\u0153\2\0\5\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\10\4\2\0\5\4\10\0"+
    "\1\4\1\0\3\4\1\u0154\10\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\4\4\2\u0155"+
    "\2\4\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\10\4\2\0\5\4\10\0\1\4\1\0\2\4\1\u0156"+
    "\11\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\1\4\2\222\5\4\2\0\5\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\10\4\2\0\5\4\10\0"+
    "\1\4\1\0\6\4\1\u0157\5\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\10\4\2\0"+
    "\4\4\1\u0158\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\10\4"+
    "\2\0\5\4\10\0\1\4\1\0\3\4\1\u0159\10\4"+
    "\1\0\2\4\1\3\3\4\1\u010a\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\5\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\1\u015a\1\4\1\0\3\4\1\u015b\4\4\2\0\1\4"+
    "\1\u015a\3\4\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\7\4"+
    "\1\u015c\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\10\4\2\0\4\4\1\70\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\5\4\10\0\1\4\1\0\11\4"+
    "\1\u015d\2\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\1\4\2\u015e\5\4\2\0\5\4"+
    "\10\0\1\4\1\0\3\4\1\u015f\10\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\3\4"+
    "\1\u0160\4\4\2\0\5\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\4\4\1\224\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\10\50\1\0\12\50\2\356\6\50"+
    "\1\0\13\50\1\u0133\15\50\46\0\1\u0161\22\0\10\50"+
    "\1\0\22\50\1\0\10\50\1\u0162\20\50\2\0\1\50"+
    "\4\u0134\1\50\1\u0134\1\50\1\0\2\50\20\u0134\1\u0135"+
    "\6\u0134\2\50\1\u0134\1\50\16\u0134\1\50\2\u0135\1\0"+
    "\1\u0135\1\u0163\2\u0135\1\0\1\u0163\4\0\1\u0163\2\u0135"+
    "\1\u0163\10\u0135\2\u0163\5\u0135\4\u0163\2\0\1\u0135\1\0"+
    "\1\u0135\1\u0163\14\u0135\1\0\2\u0135\23\0\2\354\22\0"+
    "\1\u0132\17\0\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\5\4\10\0\1\4\1\0\2\4"+
    "\1\u0164\11\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\5\4\10\0\1\4"+
    "\1\0\2\4\1\u0165\11\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\5\4"+
    "\10\0\1\4\1\0\2\4\1\u014c\11\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\7\4"+
    "\1\u0166\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\7\4\1\u0167\2\0\5\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\1\u0168\4\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\4\4\1\u0169\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\1\232\1\4\1\0\10\4\2\0\1\4\1\232"+
    "\3\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\3\4\1\120"+
    "\4\4\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\10\4\2\0\5\4\10\0\1\4\1\0\7\4\1\u0143"+
    "\4\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\1\4\2\u0145\5\4\2\0\5\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\10\4\2\0\2\4\2\u016a"+
    "\1\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\7\4\1\230"+
    "\2\0\5\4\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\10\4"+
    "\2\0\5\4\10\0\1\4\1\0\11\4\1\u016b\2\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\1\362\4\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\5\4\10\0\1\4\1\0"+
    "\1\362\13\4\1\0\1\4\1\362\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\10\4\2\0\1\u016c\4\4"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\5\4"+
    "\10\0\1\4\1\0\3\4\1\u016d\10\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\7\4"+
    "\1\362\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\4\4\2\120\2\4\2\0\5\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\1\4\2\u016e\5\4\2\0\5\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\3\4\1\u016f\4\4\2\0"+
    "\5\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\4\4\2\u0170"+
    "\2\4\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\10\4\2\0\5\4\10\0\1\4\1\0\2\4\1\u0171"+
    "\11\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\4\4\2\345\2\4\2\0\5\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\3\4\1\u0172"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\5\4"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\1\u0173\1\4\1\0\10\4\2\0"+
    "\1\4\1\u0173\3\4\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\10\4\2\0\4\4\1\u0174\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\5\4\10\0\1\4\1\0\6\4"+
    "\1\u016b\5\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\5\4\10\0\1\4"+
    "\1\0\1\u0125\13\4\1\0\1\4\1\u0125\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\5\4"+
    "\10\0\1\u016a\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\6\4\1\u0175\1\4"+
    "\2\0\5\4\10\0\1\4\1\0\14\4\1\0\1\u0175"+
    "\1\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\7\4\1\u0176\2\0\5\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\1\47\4\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\5\4\10\0\1\4\1\0"+
    "\2\4\1\u0177\11\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\1\4\2\u0178\5\4\2\0"+
    "\5\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\10\4\2\0"+
    "\5\4\10\0\1\4\1\0\3\4\1\u0179\10\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\10\4\2\0\4\4\1\u017a\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\3\4\1\u017b\4\4\2\0\5\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\5\4\10\0\1\4"+
    "\1\0\2\4\1\u017c\11\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\5\4"+
    "\10\0\1\4\1\0\6\4\1\u017d\5\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\7\4"+
    "\1\u017e\2\0\5\4\10\0\1\4\1\0\14\4\1\0"+
    "\2\4\44\0\1\u0135\22\0\10\50\1\0\22\50\1\0"+
    "\10\50\1\u0134\20\50\2\0\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\1\232\7\4\2\0\5\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\6\4\1\u0118\1\4\2\0"+
    "\5\4\10\0\1\4\1\0\14\4\1\0\1\u0118\1\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\10\4"+
    "\2\0\5\4\10\0\1\4\1\0\6\4\1\136\5\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\3\4\1\364\4\4\2\0\5\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\10\4\2\0\4\4\1\u017f\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\7\4\1\u0180\2\0\5\4"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\1\u013e\7\4\2\0"+
    "\5\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\3\4\1\u0181\1\0\2\3\4\0\2\4\1\0\10\4"+
    "\2\0\5\4\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\10\4"+
    "\2\0\5\4\10\0\1\4\1\0\3\4\1\304\10\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\5\4\10\0\1\4\1\0\5\4"+
    "\1\114\6\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\4\4\2\u0114\2\4\2\0\5\4"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\1\4\1\u0182\1\0\10\4\2\0"+
    "\5\4\10\0\1\4\1\0\1\4\1\u0182\12\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\10\4\2\0\1\u0108\4\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\1\u016f\4\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\1\u0183\1\4\1\0\10\4\2\0\1\4\1\u0183\3\4"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\7\4\1\u0184\2\0"+
    "\5\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\1\u0185\1\4\1\0\10\4"+
    "\2\0\1\4\1\u0185\3\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\1\4"+
    "\1\u0186\1\0\10\4\2\0\5\4\10\0\1\4\1\0"+
    "\1\4\1\u0186\12\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\10\4\2\0\4\4\1\u0187"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\5\4"+
    "\10\0\1\4\1\0\2\4\1\364\11\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\10\4"+
    "\2\0\5\4\10\0\1\4\1\0\2\4\1\u0188\11\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\6\4\1\u0189\1\4\2\0\5\4\10\0\1\4"+
    "\1\0\14\4\1\0\1\u0189\1\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\7\4\1\u018a\2\0\5\4"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\5\4"+
    "\10\0\1\4\1\0\14\4\1\u018b\2\4\1\3\3\4"+
    "\1\232\1\0\2\3\4\0\2\4\1\0\10\4\2\0"+
    "\5\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\2\4\1\0\10\4\2\0"+
    "\5\4\10\0\1\4\1\0\2\4\1\u0145\11\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\10\4\2\0\5\4\10\0\1\4\1\0\13\4\1\114"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\3\4\1\u018c\4\4\2\0\5\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\1\u018d\1\4\1\0\10\4\2\0\1\4\1\u018d"+
    "\3\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\1\u018e\1\4\1\0\10\4"+
    "\2\0\1\4\1\u018e\3\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\1\u018f"+
    "\1\4\1\0\10\4\2\0\1\4\1\u018f\3\4\10\0"+
    "\1\4\1\0\14\4\1\0\2\4\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\7\4\1\362\2\0\4\4"+
    "\1\u0190\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\1\4\1\362\1\0\10\4"+
    "\2\0\5\4\10\0\1\4\1\0\1\4\1\362\12\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\4\4\1\u0191\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\7\4\1\u0192\2\0\5\4\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\1\u0193\1\4\1\0\10\4\2\0\1\4\1\u0193"+
    "\3\4\10\0\1\4\1\0\14\4\1\0\2\4\23\0"+
    "\2\u0194\42\0\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\7\4\1\147\2\0\5\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\1\3\4\4\1\0\2\3\4\0"+
    "\2\4\1\0\10\4\2\0\4\4\1\u016f\10\0\1\4"+
    "\1\0\14\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\2\4\1\0\1\4\2\u0195\5\4\2\0\5\4"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\1\4\2\u0196\5\4"+
    "\2\0\5\4\10\0\1\4\1\0\14\4\1\0\2\4"+
    "\1\3\4\4\1\0\2\3\4\0\2\4\1\0\10\4"+
    "\2\0\5\4\10\0\1\4\1\0\4\4\1\324\7\4"+
    "\1\0\2\4\1\3\4\4\1\0\2\3\4\0\2\4"+
    "\1\0\10\4\2\0\5\4\10\0\1\4\1\0\11\4"+
    "\1\327\2\4\1\0\2\4\1\3\4\4\1\0\2\3"+
    "\4\0\1\137\1\4\1\0\10\4\2\0\1\4\1\137"+
    "\3\4\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\1\u0197\1\4\1\0\10\4"+
    "\2\0\1\4\1\u0197\3\4\10\0\1\4\1\0\14\4"+
    "\1\0\2\4\31\0\1\u0198\35\0\1\3\4\4\1\0"+
    "\2\3\4\0\2\4\1\0\10\4\2\0\1\u0199\4\4"+
    "\10\0\1\4\1\0\14\4\1\0\2\4\1\3\4\4"+
    "\1\0\2\3\4\0\1\4\1\u0199\1\0\10\4\2\0"+
    "\5\4\10\0\1\4\1\0\1\4\1\u0199\12\4\1\0"+
    "\2\4\1\3\4\4\1\0\2\3\4\0\2\4\1\0"+
    "\1\4\2\u019a\5\4\2\0\5\4\10\0\1\4\1\0"+
    "\14\4\1\0\2\4\35\0\1\u019b\31\0\1\3\4\4"+
    "\1\0\2\3\4\0\2\4\1\0\10\4\2\0\4\4"+
    "\1\u0190\10\0\1\4\1\0\14\4\1\0\2\4\1\3"+
    "\4\4\1\0\2\3\4\0\1\4\1\232\1\0\10\4"+
    "\2\0\5\4\10\0\1\4\1\0\1\4\1\232\12\4"+
    "\1\0\2\4\31\0\1\u019c\63\0\1\u019d\121\0\1\u019e"+
    "\33\0\1\u019f\112\0\1\u01a0\45\0\1\u01a1\35\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[22000];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\2\0\4\1\1\11\1\1\1\11\2\1\1\11\16\1"+
    "\2\11\14\1\1\11\26\1\1\11\6\1\1\0\73\1"+
    "\2\0\3\1\2\0\1\1\1\0\137\1\2\0\3\1"+
    "\2\0\100\1\1\0\3\1\1\0\52\1\1\0\1\1"+
    "\1\0\47\1\1\0\10\1\1\0\3\1\1\0\2\1"+
    "\6\0\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[417];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */


	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public VisualBasicTokenMaker() {
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addToken(int, int, int)
	 */
	private void addHyperlinkToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, true);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addHyperlinkToken(int, int, int)
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, false);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 * @param hyperlink Whether this token is a hyperlink.
	 */
	@Override
	public void addToken(char[] array, int start, int end, int tokenType,
						int startOffset, boolean hyperlink) {
		super.addToken(array, start,end, tokenType, startOffset, hyperlink);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public String[] getLineCommentStartAndEnd(int languageIndex) {
		return new String[] { "'", null };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state = YYINITIAL;

		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new TokenImpl();
		}

	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(java.io.Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public VisualBasicTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public VisualBasicTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /**
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 184) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  @Override
public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = zzLexicalState;


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 5:
          { addNullToken(); return firstToken;
          }
        case 21: break;
        case 6:
          { addToken(Token.WHITESPACE);
          }
        case 22: break;
        case 16:
          { addToken(Token.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 23: break;
        case 13:
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 24: break;
        case 15:
          { addToken(Token.RESERVED_WORD);
          }
        case 25: break;
        case 9:
          { addToken(Token.SEPARATOR);
          }
        case 26: break;
        case 2:
          { addToken(Token.IDENTIFIER);
          }
        case 27: break;
        case 11:
          { addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 28: break;
        case 7:
          { addToken(Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
          }
        case 29: break;
        case 1:
          { addToken(Token.ERROR_IDENTIFIER);
          }
        case 30: break;
        case 17:
          { addToken(Token.DATA_TYPE);
          }
        case 31: break;
        case 18:
          { addToken(Token.LITERAL_BOOLEAN);
          }
        case 32: break;
        case 14:
          { addToken(Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 33: break;
        case 19:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_EOL); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_EOL); start = zzMarkedPos;
          }
        case 34: break;
        case 20:
          { addToken(Token.RESERVED_WORD_2);
          }
        case 35: break;
        case 12:
          { addToken(Token.ERROR_NUMBER_FORMAT);
          }
        case 36: break;
        case 8:
          { start = zzMarkedPos-1; yybegin(EOL_COMMENT);
          }
        case 37: break;
        case 3:
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 38: break;
        case 4:
          { addToken(Token.OPERATOR);
          }
        case 39: break;
        case 10:
          {
          }
        case 40: break;
        default:
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case EOL_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
            }
            case 418: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 419: break;
            default:
            return null;
            }
          }
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
