package model;

import annotations.Ignore;
import util.Observable;

//TODO hier wurde angepasst
public class Hamster extends Observable implements tdd.interfaces.IHamsterProgram, tdd.interfaces.IHamster {

	final static int NORD = 0;
	final static int WEST = 1;
	final static int SUED = 2;
	final static int OST = 3;

	static Territorium territorium;

	int hamsterRow;
	int hamsterCol;
	int hamsterDirection;
	int hamsterGrains;

	protected Hamster() {
		Hamster oldHamster = Hamster.territorium.getHamster();
		this.hamsterRow = oldHamster.hamsterRow;
		this.hamsterCol = oldHamster.hamsterCol;
		this.hamsterDirection = oldHamster.hamsterDirection;
		this.hamsterGrains = oldHamster.hamsterGrains;
		Hamster.territorium.changeHamster(this);
	}

	Hamster(Territorium ter) {
		Hamster.territorium = ter;
		this.hamsterRow = 0;
		this.hamsterCol = 0;
		this.hamsterDirection = Hamster.OST;
		this.hamsterGrains = 0;
	}

	Hamster(int r, int c, int d, int g, Territorium ter) {
		Hamster.territorium = ter;
		this.hamsterRow = r;
		this.hamsterCol = c;
		this.hamsterDirection = d;
		this.hamsterGrains = g;
	}

	public void vor() throws MauerDaException {
		synchronized (Hamster.territorium) {
			switch (this.hamsterDirection) {
			case NORD:
				if (this.hamsterRow > 0
						&& !Hamster.territorium.isWallOnTile(
								this.hamsterRow - 1, this.hamsterCol)) {
					this.hamsterRow--;
				} else {
					throw new MauerDaException();
				}
				break;
			case WEST:
				if (this.hamsterCol > 0
						&& !Hamster.territorium.isWallOnTile(this.hamsterRow,
								this.hamsterCol - 1)) {
					this.hamsterCol--;
				} else {
					throw new MauerDaException();
				}
				break;
			case SUED:
				if (this.hamsterRow < Hamster.territorium.getNoOfRows() - 1
						&& !Hamster.territorium.isWallOnTile(
								this.hamsterRow + 1, this.hamsterCol)) {
					this.hamsterRow++;
				} else {
					throw new MauerDaException();
				}
				break;
			default: // case OST:
				if (this.hamsterCol < Hamster.territorium.getNoOfCols() - 1
						&& !Hamster.territorium.isWallOnTile(this.hamsterRow,
								this.hamsterCol + 1)) {
					this.hamsterCol++;
				} else {
					throw new MauerDaException();
				}
				break;
			}
		}
		this.notifyObservers();
	}

	public void linksUm() {
		synchronized (Hamster.territorium) {
			this.hamsterDirection = (this.hamsterDirection + 1) % 4;
		}
		this.notifyObservers();

	}

	public void nimm() throws KachelLeerException {
		synchronized (Hamster.territorium) {
			if (Hamster.territorium.getNoOfGrains(this.hamsterRow,
					this.hamsterCol) > 0) {
				this.hamsterGrains++;
				Hamster.territorium.changeNoOfGrains(this.hamsterRow,
						this.hamsterCol, -1);
			} else {
				throw new KachelLeerException();
			}
		}
		this.notifyObservers();

	}

	public void gib() throws MaulLeerException {
		synchronized (Hamster.territorium) {
			if (this.hamsterGrains > 0) {
				this.hamsterGrains--;
				Hamster.territorium.changeNoOfGrains(this.hamsterRow,
						this.hamsterCol, 1);
			} else {
				throw new MaulLeerException();
			}
		}
		this.notifyObservers();

	}

	public boolean vornFrei() {
		synchronized (Hamster.territorium) {
			switch (this.hamsterDirection) {
			case NORD:
				return this.hamsterRow > 0
						&& !Hamster.territorium.isWallOnTile(
								this.hamsterRow - 1, this.hamsterCol);
			case WEST:
				return this.hamsterCol > 0
						&& !Hamster.territorium.isWallOnTile(this.hamsterRow,
								this.hamsterCol - 1);
			case SUED:
				return this.hamsterRow < Hamster.territorium.getNoOfRows() - 1
						&& !Hamster.territorium.isWallOnTile(
								this.hamsterRow + 1, this.hamsterCol);
			default: // case OST:
				return this.hamsterCol < Hamster.territorium.getNoOfCols() - 1
						&& !Hamster.territorium.isWallOnTile(this.hamsterRow,
								this.hamsterCol + 1);
			}
		}
	}

	public boolean maulLeer() {
		synchronized (Hamster.territorium) {
			return this.hamsterGrains == 0;
		}
	}

	public boolean kornDa() {
		synchronized (Hamster.territorium) {
			return Hamster.territorium.getNoOfGrains(this.hamsterRow,
					this.hamsterCol) > 0;
		}
	}
	
	public int lieferReihe() {
		
		return this.hamsterRow;
	}
	
	public int lieferSpalte() {
		
		return this.hamsterCol;
	}
	
	public int lieferBlickrichtung() {
		
		return this.hamsterDirection;
	}
	
	public int lieferAnzahlKoernerImMaul() {
		
		return this.hamsterGrains;
	}
	

	public void main() {}

	
	
	@Ignore()
	void setNumberOfGrains(int numberOfGrains) {
		
		if(numberOfGrains < 0) throw new IllegalArgumentException("numberOfGrains is lower zero");
		
		if(this.hamsterGrains != numberOfGrains) {
			
			this.hamsterGrains = numberOfGrains;
			
			this.notifyObservers();
		}
	}
	
	@Ignore()
	void setDirection(int direction) {
		
		if(
				direction != NORD && 
				direction != OST && 
				direction != SUED && 
				direction != WEST) throw new IllegalArgumentException("illegal direction");
		
		if(this.hamsterDirection != direction) {
			
			this.hamsterDirection = direction;
			
			this.notifyObservers();
		}
	}
	
	
	@Ignore()
	@Override
	public int getRow() {
		
		return this.hamsterRow;
	}

	@Ignore()
	@Override
	public int getColumn() {
	
		return this.hamsterCol;
	}

	@Ignore()
	@Override
	public int getNumberOfGrains() {
		
		return this.hamsterGrains;
	}

	@Ignore()
	@Override
	public boolean isDirectionNorth() {
		
		return this.hamsterDirection == NORD;
	}

	@Ignore()
	@Override
	public boolean isDirectionWest() {
		
		return this.hamsterDirection == WEST;
	}

	@Ignore()
	@Override
	public boolean isDirectionSouth() {
		
		return this.hamsterDirection == SUED;
	}

	@Ignore()
	@Override
	public boolean isDirectionEast() {
	
		return this.hamsterDirection == OST;
	}
	
	//TODO hinzugefügt
	@Ignore()
	public static void changeTerritorium(Territorium t) {
		
		Hamster.territorium = t;
	}

	@Ignore()
	@Override
	public boolean isAheadFree() {
		
		return this.vornFrei();
	}

	@Ignore()
	@Override
	public boolean isMouthEmpty() {
	
		return this.maulLeer();
	}

	@Ignore()
	@Override
	public boolean isGrainThere() {
		
		return this.kornDa();
	}
}
