package controller.territory;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JOptionPane;

import model.Hamster;
import util.Observer;
import view.HamsterPopupMenu;
import view.Tile;
import controller.simulation.SimulationManager;
import controller.simulation.SimulationState;

public class TerritoryMouseListener extends MouseAdapter implements Observer {

	private boolean draggedHamster;

	public TerritoryMouseListener() {
		this.draggedHamster = false;
	}

	@Override
	public void mouseClicked(MouseEvent e) {
		if (e.isPopupTrigger()) {
			this.handlePopupTrigger(e);
		}
	}

	@Override
	public void mousePressed(MouseEvent e) {
		if (e.isPopupTrigger()) {
			this.handlePopupTrigger(e);
		} else if (e.getButton() == MouseEvent.BUTTON1) {
			TerritoryManager manager = TerritoryManager.getTerritoryManager();
			Tile tile = manager.getTerritoriumPanel().getTile(e.getX(),
					e.getY());
			if (tile != null) {
				if (manager.getTerritorium().isHamsterOnTile(tile.getRow(),
						tile.getCol())) {
					
					if (SimulationManager.getSimulationManager().getState() == SimulationState.NOT_RUNNING) {
						
						if (manager.getDesignButtonChoice() == TerritoryManager.CORN) {
							
							String result = JOptionPane.showInputDialog("Anzahl Körner im Maul angeben", manager.getTerritorium().getHamster().getNumberOfGrains());
							
							if(result != null) {
								
								try {
									
									manager.getTerritorium().setHamsterNumberOfGrains(Integer.parseInt(result));
									
								} catch (Exception e2) {
								
									JOptionPane.showMessageDialog(null, "Angabe falsch", null, JOptionPane.ERROR_MESSAGE);
								}
							}
									
						} else {
							
							this.draggedHamster = true;
						}
					}
				} else {
					this.draggedHamster = false;
					if (manager.getDesignButtonChoice() == TerritoryManager.CORN) {
						manager.getTerritorium().changeNoOfGrains(tile.getRow(), tile.getCol(), 1);
						
					} else if (manager.getDesignButtonChoice() == TerritoryManager.WALL) {
						manager.getTerritorium().setWall(tile.getRow(),
								tile.getCol());
					} else if (manager.getDesignButtonChoice() == TerritoryManager.CLEAR) {
						manager.getTerritorium().clear(tile.getRow(),
								tile.getCol());
					}
				}
			}
		}
	}

	@Override
	public void mouseDragged(MouseEvent e) {
		if (this.draggedHamster) {
			TerritoryManager manager = TerritoryManager.getTerritoryManager();
			Tile tile = manager.getTerritoriumPanel().getTile(e.getX(),
					e.getY());
			if (tile != null
					&& !manager.getTerritorium().isHamsterOnTile(tile.getRow(),
							tile.getCol())) {
				manager.getTerritorium().setHamsterOnTile(tile.getRow(),
						tile.getCol());
			}
		}
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		if (e.isPopupTrigger()) {
			this.handlePopupTrigger(e);
		}
		this.draggedHamster = false;
	}

	private void handlePopupTrigger(MouseEvent e) {
		Hamster hamster = TerritoryManager.getTerritoryManager()
				.getTerritoriumPanel().getHamster(e.getX(), e.getY());
		if (hamster != null
				&& SimulationManager.getSimulationManager().getState() == SimulationState.NOT_RUNNING) {
			HamsterPopupMenu hamsterMenu = new HamsterPopupMenu();
			hamsterMenu.show(e.getComponent(), e.getX(), e.getY());
		}
	}

	@Override
	public void update() {
		SimulationState currentState = SimulationManager.getSimulationManager()
				.getState();
		if (currentState == SimulationState.RUNNING) {
			this.draggedHamster = false;
		}
	}

}
