package controller.territory;

import model.Hamster;
import model.Territorium;
import tdd.interfaces.IStateManager;
import tdd.interfaces.ITerritory;
import view.TerritoriumPanel;

public class TerritoryManager implements IStateManager {

	public final static int NOTHING = 0;
	public final static int CORN = 1;
	public final static int WALL = 2;
	public final static int CLEAR = 3;

	private static TerritoryManager territoryManager = null;

	private int choice;
	private TerritoriumPanel territoriumPanel;
	private Territorium territorium;

	public static TerritoryManager getTerritoryManager() {
		if (TerritoryManager.territoryManager == null) {
			TerritoryManager.territoryManager = new TerritoryManager();
		}
		return TerritoryManager.territoryManager;
	}

	private TerritoryManager() {
		this.choice = TerritoryManager.NOTHING;
		this.territoriumPanel = null;
	}

	public void setTerritorium(Territorium terr) {
		this.territorium = terr;
	}

	public Territorium getTerritorium() {
		return this.territorium;
	}

	public void setTerritoriumPanel(TerritoriumPanel p) {
		this.territoriumPanel = p;
	}

	public TerritoriumPanel getTerritoriumPanel() {
		return this.territoriumPanel;
	}

	public void setDesignButtonChoice(int choice) {
		this.choice = choice;
	}

	public int getDesignButtonChoice() {
		return this.choice;
	}

	public boolean print() {
		return this.territoriumPanel.print();
	}

	
	
	@Override
	public ITerritory getTerritoryState() {
		
		return this.getTerritorium();
	}

	@Override
	public void setTerritoryState(ITerritory territory) {
		
		Territorium t = this.getTerritorium();
		
		t.setSize(territory.getNumberOfRows(), territory.getNumberOfColumns());
		t.clear();
		
		t.setHamsterOnTile(territory.getHamsterState().getRow(), territory.getHamsterState().getColumn());
		
		for(int i=0; i<t.getNumberOfRows(); i++) {
			
			for(int j=0; j<t.getNumberOfColumns(); j++) {
				
				t.setNoOfGrains(i, j, territory.getNumberOfGrainsOnTile(i, j));
				
				if(territory.isWallOnTile(i, j)) {
					
					t.setWall(i, j);
				}
			}
		}
		
		int direction = Territorium.NORD;
		
		if(territory.getHamsterState().isDirectionEast()) {
			
			direction = Territorium.OST;
			
		} else if(territory.getHamsterState().isDirectionSouth()) {
			
			direction = Territorium.SUED;
			
		} else if(territory.getHamsterState().isDirectionWest()) {
			
			direction = Territorium.WEST;
		}
		
		t.setHamsterDirection(direction);
		t.setHamsterNumberOfGrains(territory.getHamsterState().getNumberOfGrains());
	}

	@Override
	public void resetHamsterTerritoryState() {
		
		Hamster.changeTerritorium(TerritoryManager.getTerritoryManager().getTerritorium());
	}
}
