package controller.territory;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SerializeTerritoryListener implements ActionListener {

	private JFileChooser chooser;

	public SerializeTerritoryListener() {
		this.chooser = new JFileChooser();
		FileNameExtensionFilter filter = new FileNameExtensionFilter("Territorium-SER-Dateien", "ser");
		this.chooser.setFileFilter(filter);
	}

	public void actionPerformed(ActionEvent e) {
		int returnVal = this.chooser.showSaveDialog(null);
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			String filename = this.chooser.getSelectedFile().getAbsolutePath();
			TerritoryManager.getTerritoryManager().getTerritorium().serialize(filename);
		}
	}

}
