package controller.territory;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JOptionPane;

import tdd.TDDFramework;
import tdd.models.TerritoryState;
import controller.TDDFrameworkContainer;

public class SaveTerritoryListener implements ActionListener {

	public SaveTerritoryListener() {}

	public void actionPerformed(ActionEvent e) {
		
		boolean write = false;
		
		String name = JOptionPane.showInputDialog("Bitte Namen angeben");
		TDDFramework framework = TDDFrameworkContainer.getTDDFramework();
		
		while(name != null && !write) {
			
			if(name.length() == 0) {
				
				JOptionPane.showMessageDialog(null, "Der Name ist zu kurz");
				name = JOptionPane.showInputDialog("Bitte Namen angeben");
				
			} else if(framework.getTerritoryStates().exists(name)) {
				
				if(JOptionPane.OK_OPTION == JOptionPane.showConfirmDialog(null, "Der Zustand existiert bereits. Möchten Sie diesen überschreiben?")) {
					
					write = true;
					
				} else {
					
					name = JOptionPane.showInputDialog("Bitte Namen angeben");
				}
				
			} else {
				
				write = true;
			}
			
			if(write) {
				
				TerritoryState state = new TerritoryState(name, TerritoryManager.getTerritoryManager().getTerritorium());
				framework.getTerritoryStateController().saveTerritoryState(state);
			}
		}
	}

}
