package controller.territory;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.WindowConstants;

import model.Territorium;
import util.Resources;

public class ChangeSizeListener implements ActionListener {

	private JMenuItem item;
	private JMenu menu;

	public ChangeSizeListener(JMenuItem item, JMenu menu) {
		this.item = item;
		this.menu = menu;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		SizeDialog dialog = new SizeDialog(TerritoryManager
				.getTerritoryManager().getTerritorium());
		Point p = this.item.getLocation();
		SwingUtilities.convertPointToScreen(p, this.menu);
		dialog.setLocation(p.x, p.y);
		dialog.setVisible(true);
	}

}

class SizeDialog extends JDialog {
	JTextField rows;
	JTextField cols;
	Territorium territorium;

	public SizeDialog(Territorium territorium) {
		super((Frame) null, Resources.getValue("size.title"), true);
		this.territorium = territorium;

		this.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		this.setLayout(new BorderLayout(20, 20));
		
		
		JPanel topPanel = new JPanel();
		topPanel.setLayout(new BorderLayout());
		
		JPanel lFiller = new JPanel();
		lFiller.setPreferredSize(new Dimension(10, 10));
		topPanel.add(lFiller, BorderLayout.WEST);
		
		JPanel rFiller = new JPanel();
		rFiller.setPreferredSize(new Dimension(10, 10));
		topPanel.add(rFiller, BorderLayout.EAST);
		
		JPanel contentPanel = new JPanel();
		contentPanel.setLayout(new BorderLayout());
		
		JPanel labelPanel = new JPanel();
		labelPanel.setLayout(new BorderLayout());

		JLabel nR = new JLabel(Resources.getValue("size.rows") + ": ");
		labelPanel.add(nR, BorderLayout.NORTH);
		
		JLabel nS = new JLabel(Resources.getValue("size.cols") + ": ");
		labelPanel.add(nS, BorderLayout.SOUTH);
		
		contentPanel.add(labelPanel, BorderLayout.WEST);
		
		JPanel textFieldPanel = new JPanel();
		textFieldPanel.setLayout(new BorderLayout());
		
		this.rows = new JTextField(15);
		this.rows.setText("" + territorium.getNoOfRows());
		this.rows.addActionListener(new OKButtonAction(this));
		textFieldPanel.add(this.rows, BorderLayout.NORTH);

		this.cols = new JTextField(15);
		this.cols.setText("" + territorium.getNoOfCols());
		this.cols.addActionListener(new OKButtonAction(this));
		textFieldPanel.add(this.cols, BorderLayout.SOUTH);

		contentPanel.add(textFieldPanel, BorderLayout.EAST);
		
		JPanel tFiller = new JPanel();
		tFiller.setPreferredSize(new Dimension(10, 10));
		
		topPanel.add(tFiller, BorderLayout.NORTH);
		topPanel.add(contentPanel, BorderLayout.CENTER);
		this.add(topPanel, BorderLayout.CENTER);
		
		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER));

		JButton ok = new JButton(Resources.getValue("size.ok"));
		ok.addActionListener(new OKButtonAction(this));
		buttonPanel.add(ok);

		JButton cancel = new JButton(Resources.getValue("size.cancel"));
		cancel.addActionListener(new CancelButtonAction(this));
		buttonPanel.add(cancel);
		this.add(buttonPanel, BorderLayout.SOUTH);

		this.pack();
		this.setResizable(false);
	}
}

class OKButtonAction implements ActionListener {
	SizeDialog dialog;

	OKButtonAction(SizeDialog d) {
		this.dialog = d;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		try {
			int cols = new Integer(this.dialog.cols.getText());
			int rows = new Integer(this.dialog.rows.getText());

			// mindestens 1 Reihe und 1 Spalte
			if (cols < 1) {
				cols = 1;
			}

			if (rows < 1) {
				rows = 1;
			}

			int oldRows = this.dialog.territorium.getNoOfRows();
			int oldCols = this.dialog.territorium.getNoOfCols();
			try {
				this.dialog.territorium.setSize(rows, cols);
			} catch (Throwable th) {
				// Heap Probleme bei zu groen Werten
				this.dialog.territorium.setSize(oldRows, oldCols);
			}

			this.dialog.dispose();
		} catch (NumberFormatException exc) {
		}
	}
}

class CancelButtonAction implements ActionListener {
	JDialog dialog;

	CancelButtonAction(JDialog d) {
		this.dialog = d;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		this.dialog.dispose();
	}
}