package controller.simulation;

import javax.swing.JOptionPane;

import controller.program.CompileManager;
import tdd.interfaces.IHamsterProgram;
import tdd.interfaces.ISimulationManager;
import util.Observable;
import util.Resources;

public class SimulationManager extends Observable implements ISimulationManager {

	public final static int MIN_SPEED = 0;
	public final static int MAX_SPEED = 100;
	public final static int DEF_SPEED = 50;

	private Simulation simulation;
	private SimulationState state;
	private int speed;
	//TODO angepasst...
	private tdd.interfaces.SimulationState simulationState = new tdd.interfaces.SimulationState();
	//---------------

	private static SimulationManager simulationManager = null;

	public static SimulationManager getSimulationManager() {
		if (SimulationManager.simulationManager == null) {
			SimulationManager.simulationManager = new SimulationManager();
		}
		return SimulationManager.simulationManager;
	}

	private SimulationManager() {
		this.simulation = null;
		this.state = SimulationState.NOT_RUNNING;
		this.speed = SimulationManager.DEF_SPEED;
	}
	
	
	//TODO angepasst...
	public tdd.interfaces.SimulationState getSimulationState() {
		
		return this.simulationState;
	}
	//--------------

	public synchronized void setSpeed(int speed) {
		this.speed = speed;
	}

	public synchronized int getSpeed() {
		return this.speed;
	}

	public SimulationState getState() {
		return this.state;
	}

	public void run() {
		if (this.state == SimulationState.NOT_RUNNING) {
			this.start();
		} else {
			this.resume();
		}
	}
	
	//TODO angepasst......
	public void run(IHamsterProgram program) {
		if (this.state == SimulationState.NOT_RUNNING) {
			this.start(program);
		} else {
			this.resume();
		}
	}
	//-------------------

	public void start() {

		if(!CompileManager.getCompileManager().getCompiledState().isCompiled()) {
			
			boolean compiled = CompileManager.getCompileManager().compileAndReload(true);

			if(compiled) {

				JOptionPane.showMessageDialog(null,
						Resources.getValue("compile.success"),
						Resources.getValue("compile.title"),
						JOptionPane.INFORMATION_MESSAGE);
			}
		}
		
		if(CompileManager.getCompileManager().getCompiledState().isCompiled()) {
			
			//TODO angepasst...
			this.simulationState.setRunning(true);
			//------
					
			this.simulation = new Simulation();
			this.simulation.startSimulation();
			this.state = SimulationState.RUNNING;
			
			this.notifyObservers();
		}
	}
	
	//TODO angepasst......
	public void start(IHamsterProgram program) {
		
		if(!CompileManager.getCompileManager().getCompiledState().isCompiled()) {
			
			boolean compiled = CompileManager.getCompileManager().compileAndReload(true);

			if(compiled) {

				JOptionPane.showMessageDialog(null,
						Resources.getValue("compile.success"),
						Resources.getValue("compile.title"),
						JOptionPane.INFORMATION_MESSAGE);
			}
		}
		
		if(CompileManager.getCompileManager().getCompiledState().isCompiled()) {

			//TODO angepasst...
			this.simulationState.setRunning(true);
			//------
			
			this.simulation = new Simulation(program);
			this.simulation.startSimulation();
			this.state = SimulationState.RUNNING;

			this.notifyObservers();
		}
	}
	//-------------------

	public void resume() {
		this.simulation.resumeSimulation();
		this.state = SimulationState.RUNNING;
		this.notifyObservers();
	}

	public void pause() {
		this.simulation.pauseSimulation();
		this.state = SimulationState.PAUSED;
		this.notifyObservers();
	}

	public void stop() {
		this.simulation.stopSimulation();
	}

	public void simulationEnded() {
		// wird in Simulation aufgerufen
		this.simulation = null;
		this.state = SimulationState.NOT_RUNNING;

		//TODO angepasst...
		this.simulationState.setRunning(false);
		//------
		
		this.notifyObservers();
	}

	@Override
	public void sleep() {
		
		if(this.simulation != null) {
			
			this.simulation.sleep();
		}
	}
}
