package controller.simulation;

import javax.swing.SwingUtilities;

import model.Hamster;
import model.KachelLeerException;
import model.MauerDaException;
import model.MaulLeerException;
import model.Territorium;
import tdd.interfaces.IHamsterProgram;
import util.Observer;
import util.Sound;
import controller.program.CompileManager;
import controller.territory.TerritoryManager;

//Anmerkung:
//Synchronisation notwendig, weil der Pause- bzw. Stop-Button via des EventDispatchers gedr�ckt werden,
//gleichzeitig aber der Simulation-Thread abfragt, ob die Buttosn gedr�ckt wurden

public class Simulation extends Thread implements Observer {

	private IHamsterProgram program; //TODO angepasst...
	private Territorium territorium;
	private Hamster hamster;
	private boolean pause;
	private boolean stop;
	private boolean stopAccepted;
	private Object syncObject;

	public Simulation() {
		CompileManager.getCompileManager().loadAndSetNewHamster();
		this.territorium = TerritoryManager.getTerritoryManager().getTerritorium();
		
		Hamster.changeTerritorium(territorium);
		
		this.hamster = territorium.getHamster();
		this.program = this.hamster;
		
		this.pause = false;
		this.stop = false;
		this.stopAccepted = false;
		this.syncObject = new Object();
	}
	
	//TODO angepasst...
	public Simulation(IHamsterProgram program) {
		
		this.program = program;
		this.territorium = TerritoryManager.getTerritoryManager().getTerritorium();
		Hamster.changeTerritorium(territorium);
		
		this.hamster = territorium.getHamster();

		this.pause = false;
		this.stop = false;
		this.stopAccepted = false;
		this.syncObject = new Object();
	}
	//--------------------

	@Override
	public void run() {
		
		boolean forceReinit = false;
		try {
			
			//TODO angepasst...
			this.program.main();
			//this.hamster.main();
			//----------------
			
		} catch (ThreadDeath exc) {
			// brutaler Stop
			forceReinit = true;
		} catch (SimulationStoppedException exc) {
			// Stop
		} catch (KachelLeerException exc) {
			Sound.death();
		} catch (MauerDaException exc) {
			Sound.death();
		} catch (MaulLeerException exc) {
			Sound.death();
		} catch (Throwable exc) {
			exc.printStackTrace();
			forceReinit = true;
		} finally {
			Simulation.this.hamster.deleteObserver(this);
			SwingUtilities.invokeLater(new Runnable() {
				public void run() {
					SimulationManager.getSimulationManager().simulationEnded();
				}
			});

			if (forceReinit) {
				// notwendig, weil durch das stop der alte Hamster u.U. in einem
				// inkonsistenten Zustand ist
				CompileManager.getCompileManager().loadAndSetNewHamster();
			}
		}

	}

	// wird innerhalb des Simulation-Threads ausgef�hrt;
	// zun�chst wird der Hamster-Befehl ausgef�hrt,
	// dann werden u.U. �nderungen im Simulationspanel angezeigt (erster
	// Observer),
	// danach wird diese Methode ausgef�hrt,
	// dann kann der n�chste Befehl folgende
	public void update() {
		try {
			Thread.sleep(SimulationManager.MAX_SPEED * 4
					- SimulationManager.getSimulationManager().getSpeed() * 4);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		synchronized (this.syncObject) {
			while (this.pause) {
				try {
					this.syncObject.wait();
				} catch (InterruptedException e) {
				}
			}
			if (this.stop) {
				this.stopAccepted = true;
				this.syncObject.notify();
				throw new SimulationStoppedException();
			}
		}
	}

	public void startSimulation() {
		this.pause = false;
		this.stop = false;
		this.stopAccepted = false;
		this.hamster.addObserver(this);
		this.start();
	}

	public void pauseSimulation() {
		synchronized (this.syncObject) {
			this.pause = true;
			this.hamster.deleteObserver(this);
		}
	}

	public void resumeSimulation() {
		synchronized (this.syncObject) {
			this.hamster.addObserver(this);
			this.pause = false;
			this.syncObject.notify();
		}
	}

	public boolean isPaused() {
		synchronized (this.syncObject) {
			return this.pause;
		}
	}

	@SuppressWarnings("deprecation")
	public void stopSimulation() {
		synchronized (this.syncObject) {
			this.pause = false;
			this.stop = true;
			this.syncObject.notify();
			try {
				this.syncObject.wait(1000);
			} catch (InterruptedException e) {
			}
			if (!this.stopAccepted) {
				// wenn der Simulationsthread nach 1 Sekunde noch nicht reagiert
				// hat, wird er abgeschossen
				synchronized (this.territorium) {
					System.out.println("stop called");
					this.stop();
				}
				try {
					this.join();
				} catch (InterruptedException e) {
				}
			}
		}
	}

	public boolean isStopped() {
		synchronized (this.syncObject) {
			return this.stop;
		}
	}

	public void sleep() {
		
		try {
			
			Thread.sleep(SimulationManager.MAX_SPEED * 4 - SimulationManager.getSimulationManager().getSpeed() * 4);
			
		} catch (InterruptedException e) {
			
			e.printStackTrace();
		}
	}
}

class SimulationStoppedException extends RuntimeException {

}
