package controller.simulation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import model.HamsterException;
import model.Territorium;
import util.Sound;
import controller.program.CompileManager;

public class MethodInvocation implements ActionListener {

	private Method method;
	private Object obj;
	private Territorium territorium;

	public MethodInvocation(Method m, Object o, Territorium ter) {
		this.method = m;
		this.obj = o;
		this.territorium = ter;
	}

	@Override
	@SuppressWarnings("deprecation")
	public void actionPerformed(ActionEvent e) {
		// Methoden knnen nicht whrend einer laufenden Simulation ausgefhrt
		// werden
		if (SimulationManager.getSimulationManager().getState() == SimulationState.RUNNING) {
			return;
		}

		// sollte nach Aufruf des Popup-Mens und Auswahl der Methode der
		// Hamster gewechselt worden sein,
		// darf die Methode nicht ausgefhrt werden
		if (this.obj != this.territorium.getHamster()) {
			return;
		}
		final Thread callThread = new Thread() {
			@Override
			public void run() {
				try {
					MethodInvocation.this.territorium.deactivateNotification();
					MethodInvocation.this.method.setAccessible(true);
					MethodInvocation.this.method.invoke(
							MethodInvocation.this.obj, (Object[]) null);
				} catch (IllegalArgumentException exc) {
					exc.printStackTrace();
				} catch (IllegalAccessException exc) {
					exc.printStackTrace();
				} catch (InvocationTargetException exc) {
					if (exc.getCause().getClass() != ThreadDeath.class) {
						Sound.death();
						if (!(exc.getCause() instanceof HamsterException)) {
							exc.getCause().printStackTrace();
						}
					} else {
						// notwendig, weil durch das stop der alte Hamster u.U.
						// in einem inkonsistenten Zustand ist
						CompileManager.getCompileManager()
								.loadAndSetNewHamster();
					}
				} finally {
					MethodInvocation.this.territorium.activateNotification();
				}
			}
		};
		Thread destroyThread = new Thread() {
			@Override
			public void run() {
				try {
					callThread.join(5000);
				} catch (InterruptedException e) {
				}
				if (callThread.isAlive()) {
					callThread.stop();
				}
			}
		};

		callThread.start();
		destroyThread.start();
		try {
			callThread.join();
		} catch (InterruptedException e1) {
			e1.printStackTrace();
		}
	}
}
