package controller.program;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JOptionPane;

public class WorkspaceController {

	private static WorkspaceController instance;
	
	private Workspace workspace;

	private WorkspaceController() {}
	
	public Workspace getWorkspace() {
		
		return this.workspace;
	}
	
	public void initialize(File workspaceDirectory) {
		
		if(!workspaceDirectory.exists()) {
			
			if(!workspaceDirectory.mkdirs()) {
				
				JOptionPane.showInternalMessageDialog(null, "Arbeitsmappe kann nicht geladen werden", null, JOptionPane.ERROR_MESSAGE);
				
				return;
			}
			
		} else {
			
			if(!workspaceDirectory.isDirectory()) {
				
				JOptionPane.showInternalMessageDialog(null, "Arbeitsmappe kann nicht geladen werden", null, JOptionPane.ERROR_MESSAGE);
				
				return;
			}
		}
		
		File[] programDirectories = workspaceDirectory.listFiles();
		List<Program> programs = new ArrayList<Program>();
		
		for(File programDirectory : programDirectories) {
			
			if(programDirectory.isDirectory()) {
				
				programs.add(new Program(programDirectory));
			}
		}
		
		this.workspace = new Workspace(workspaceDirectory, programs.toArray(new Program[programs.size()]));
	}
	
	public static WorkspaceController getInstance() {
		
		if(instance == null) instance = new WorkspaceController();
		
		return instance;
	}
	
	public void createProgram(String name, boolean open) {
		
		File directory = new File(this.workspace.getDirectory(), name);
		directory.mkdirs();
		
		Program program = new Program(directory);
		this.workspace.addProgram(program);
		
		if(open) {
			
			ProgramManager.getProgramManager().openProgram(program);
		}
	}
}
