package controller.program;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

import util.Observable;

public class Workspace extends Observable {

	private File directory;
	private List<Program> programs = new ArrayList<Program>();
	
	public Workspace(File directory, Program[] programs) {
	
		this.setDirectory(directory);
		this.programs.addAll(Arrays.asList(programs));
	}
	
	public File getDirectory() {
		
		return this.directory;
	}
	
	void setDirectory(File directory) {
		
		if(directory == null) throw new IllegalArgumentException("directory is NULL");
		if(!directory.exists()) throw new IllegalArgumentException("directory does not exists");
		if(!directory.isDirectory()) throw new IllegalArgumentException("directory is not a directory");
		
		if(!Objects.equals(this.getDirectory(), directory)) {
			
			this.directory = directory;
			
			this.notifyObservers();
		}
	}
	
	public boolean contains(String name) {
		
		for(Program program : this.programs) {
			
			if(program.getDirectory().getName().equalsIgnoreCase(name)) {
				
				return true;
			}
		}
		
		return false;
	}
	
	public Program[] getPrograms() {
		
		return this.programs.toArray(new Program[this.programs.size()]);
	}
	
	public Program getProgram(int index) {
		
		return this.programs.get(index);
	}
	
	public int getNumberOfPrograms() {
		
		return this.programs.size();
	}
	
	void addProgram(Program program) {
		
		if(this.programs.add(program)) {
			
			this.notifyObservers();
		}
	}
	
	void removeProgram(Program program) {
		
		if(this.programs.remove(program)) {
			
			this.notifyObservers();
		}
	}
}
