package controller.program;



import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import model.Territorium;
import controller.TDDFrameworkContainer;
import controller.simulation.SimulationManager;
import controller.territory.TerritoryManager;
import tdd.interfaces.IProgramManager;
import tdd.utils.Files;
import view.Editor;
import view.ProgramDialog;
import view.SimulatorFrame;



public class ProgramManager implements IProgramManager {

	
	public static final String CLASS_NAME = "HamsterProgram";

	private Editor editor;
	private Program program;
	private SimulatorFrame frame;

	private static ProgramManager programManager = null;

	public static ProgramManager getProgramManager() {
		
		return ProgramManager.programManager;
	}
	
	public static void initialize(Program program) {
		
		ProgramManager.programManager = new ProgramManager(program);
	}
	

	private ProgramManager(Program program) {
		this.editor = null;
		this.program = program;
	}


	
	public Program getProgram() {
		
		return this.program;
	}
	
	public void openProgram(Program program) {
		
		File file = new File(this.getProgram().getDirectory(), ProgramManager.CLASS_NAME + ".java");
		if(!file.exists()) {
			
			this.createHamsterProgram();
		}
		
		if(frame != null) {
			
			frame.setVisible(false);
			frame.dispose();
		}
		
		this.program = program;
		this.editor = null;
		Territorium territorium = new Territorium();
		TerritoryManager.getTerritoryManager().setTerritorium(territorium);
	
		//TODO angepasst...
		TDDFrameworkContainer.initialize(
				CompileManager.getCompileManager(), 
				ProgramManager.getProgramManager(), 
				SimulationManager.getSimulationManager(),
				SimulationManager.getSimulationManager().getSimulationState(),
				TerritoryManager.getTerritoryManager(),
				CompileManager.getCompileManager().getCompiledState(),
				new File(ProgramManager.getProgramManager().getProgram().getDirectory(), "tdd"), 
				new File(ProgramManager.getProgramManager().getProgram().getDirectory(), "tests"),
				new File(ProgramManager.getProgramManager().getProgram().getDirectory(), "territories")
			);
		//------------------
		
		if (CompileManager.getCompileManager().compile()) {
			CompileManager.getCompileManager().loadAndSetNewHamster();
		}
		
		this.frame = new SimulatorFrame(territorium, program);
		this.frame.setLocation(150, 100);
		this.frame.setVisible(true);
	}
	
	public void deleteProgram() {
		
		Files.delete(program.getDirectory());
		WorkspaceController.getInstance().getWorkspace().removeProgram(this.program);
		this.program = null;
		
		if(frame != null) {
			
			frame.setVisible(false);
			frame.dispose();
		}

		ProgramDialog dialog = new ProgramDialog();
		dialog.setVisible(true);
		
		if(dialog.isCommited()) {
			
			ProgramManager.getProgramManager().openProgram(dialog.getProgram());
			
		} else {
			
			System.exit(0);
		}
	}
	
	public void setEditor(Editor editor) {
		this.editor = editor;
	}

	public boolean print() {
		if (this.editor == null) {
			return false;
		}
		try {
			
			return this.editor.print();
			
		} catch (PrinterException e) {

			e.printStackTrace();
		}
		
		return false;
	}

	public boolean saveHamsterProgram() {
		
		String code = null;
		File file = new File(this.getProgram().getDirectory(), ProgramManager.CLASS_NAME + ".java");
		
		if (this.editor == null) {
			
			if(!file.exists()) {
				
				code = this.createHamsterProgram();
				
			} else {
				
				return false;
			}
			
		} else {
			
			code = this.editor.getText();
		}

		FileWriter fw = null;
		try {
			
			fw = new FileWriter(file);
			fw.write(ProgramManager.getPrefix() + code + ProgramManager.getPostfix());
			fw.flush();
			return true;
		} catch (IOException exc) {
			exc.printStackTrace();
			return false;
		} finally {
			if (fw != null) {
				try {
					fw.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	public String getHamsterProgram() {
		File dir = this.getProgram().getDirectory();
		if (!dir.exists()) {
			dir.mkdir();
		}
		File file = new File(this.getProgram().getDirectory(), ProgramManager.CLASS_NAME + ".java");
		if (!file.exists()) {
			return this.createHamsterProgram();
		} else {
			return this.readHamsterProgram();
		}
	}

	private String createHamsterProgram() {
		String code = "void main() {\n    \n}";
		FileWriter fw = null;
		try {
			File file = new File(this.getProgram().getDirectory(), ProgramManager.CLASS_NAME + ".java");
			fw = new FileWriter(file);
			fw.write(ProgramManager.getPrefix() + code
					+ ProgramManager.getPostfix());
			fw.flush();
		} catch (IOException exc) {
			exc.printStackTrace();
		} finally {
			if (fw != null) {
				try {
					fw.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return code;
	}

	private String readHamsterProgram() {
		StringBuffer text = new StringBuffer();
		FileReader fr = null;
		try {
			File file = new File(this.getProgram().getDirectory(), ProgramManager.CLASS_NAME + ".java");
			fr = new FileReader(file);
			int ch;
			while ((ch = fr.read()) != -1) {
				text.append((char) ch);
			}
			text.delete(0, ProgramManager.getPrefix().length());
			text.delete(text.length() - ProgramManager.getPostfix().length(),
					text.length());
		} catch (IOException exc) {
			exc.printStackTrace();
		} finally {
			if (fr != null) {
				try {
					fr.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return text.toString();
	}

	private static String getPrefix() {
		return "public class " + ProgramManager.CLASS_NAME
				+ " extends model.Hamster { public ";
	}

	private static String getPostfix() {
		return " }";
	}

	@Override
	public File getProgramDirectory() {
		
		return this.getProgram().getDirectory();
	}
}
