package controller.program;

import java.io.File;
import java.util.Objects;

import util.Observable;

public class Program extends Observable {

	private File directory;
	
	public Program(File directory) {
	
		this.setDirectory(directory);
	}
	
	public File getDirectory() {
		
		return this.directory;
	}
	
	public void setDirectory(File directory) {
		
		if(directory == null) throw new IllegalArgumentException("directory is NULL");
		if(!directory.exists()) throw new IllegalArgumentException("directory does not exists");
		if(!directory.isDirectory()) throw new IllegalArgumentException("directory is not a directory");
		
		if(!Objects.equals(this.getDirectory(), directory)) {
			
			this.directory = directory;
			
			this.notifyObservers();
		}
	}
	
	@Override
	public String toString() {
		
		return this.getDirectory().getName();
	}
}