package controller.program;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

public class CreateProgramListener implements ActionListener {

	private boolean open;
	
	public CreateProgramListener(boolean open) {
	
		this.open = open;
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {

		String input = JOptionPane.showInputDialog("Name angeben:");
		
		if(input != null) {
			
			if(input.length() == 0) {

				JOptionPane.showMessageDialog(null, "Der Name ist zu kurz", null, JOptionPane.ERROR_MESSAGE);
				
			} else if(WorkspaceController.getInstance().getWorkspace().contains(input)) {
				
				JOptionPane.showMessageDialog(null, "Das Program existiert bereits", null, JOptionPane.ERROR_MESSAGE);
				
			} else {
				
				WorkspaceController.getInstance().createProgram(input, open);
			}
		}
	}
}
