package controller.program;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.swing.JOptionPane;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaCompiler.CompilationTask;
import javax.tools.JavaFileObject;
import javax.tools.JavaFileObject.Kind;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

import controller.TDDFrameworkContainer;
import tdd.interfaces.CompiledState;
import tdd.interfaces.ICompileErrorFixer;
import tdd.interfaces.ICompilerManager;
import util.Resources;

public class CompileManager implements ICompilerManager {

	private static CompileManager compileManager = null;

	private ClassLoader classLoader;
	private CompiledState compilingState = new CompiledState();

	private CompileManager() {
		this.compileAndReload(false);
	}
	
	public CompiledState getCompiledState() {
		
		return this.compilingState;
	}

	public static CompileManager getCompileManager() {
		if (CompileManager.compileManager == null) {
			CompileManager.compileManager = new CompileManager();
		}
		return CompileManager.compileManager;
	}
	
	public boolean compile() {
		try {
			
			ProgramManager.getProgramManager().saveHamsterProgram();
			JavaCompiler javac = ToolProvider.getSystemJavaCompiler();
			FileOutputStream file = new FileOutputStream("compiler.tmp");

			boolean success = javac.run(null, null, file, ProgramManager.getProgramManager().getProgram().getDirectory().getAbsolutePath() + File.separator + ProgramManager.CLASS_NAME + ".java") == 0;
			
			if (!success) {
	
				String msg = "";
				BufferedReader in = null;
				in = new BufferedReader(new FileReader("compiler.tmp"));
				String line = null;
				while ((line = in.readLine()) != null) {
					msg += line + "\n";
				}
				JOptionPane.showMessageDialog(null, msg, Resources.getValue("compile.title"), JOptionPane.ERROR_MESSAGE);
					
			} else {
				
				//TODO angepast
				TDDFrameworkContainer.getTDDFramework().save();
				success = TDDFrameworkContainer.getTDDFramework().compile(ProgramManager.CLASS_NAME);
				
				if(success) {
					
					this.getCompiledState().setCompiled(true);
				}
				//----------------------------------
			}
			
			return success;
			
		} catch (FileNotFoundException exc) {

			JOptionPane.showMessageDialog(null, exc.toString(),
					Resources.getValue("compile.title"), JOptionPane.ERROR_MESSAGE);
			
			return false;
		} catch (IOException e) {

			JOptionPane.showMessageDialog(null, e.toString(),
					Resources.getValue("compile.title"), JOptionPane.ERROR_MESSAGE);
			
			return false;
		}
	}

	public boolean compileAndReload(boolean successMessage) {
		try {

			
			ProgramManager.getProgramManager().saveHamsterProgram();
			JavaCompiler javac = ToolProvider.getSystemJavaCompiler();
			FileOutputStream file = new FileOutputStream("compiler.tmp");

			boolean success = javac.run(null, null, file,  
					ProgramManager.getProgramManager().getProgram().getDirectory().getAbsolutePath() + File.separator 
							+ ProgramManager.CLASS_NAME + ".java") == 0;

			if (!success) {
				
				if (successMessage) {
					String msg = "";
					BufferedReader in = null;
					in = new BufferedReader(new FileReader("compiler.tmp"));
					String line = null;
					while ((line = in.readLine()) != null) {
						msg += line + "\n";
					}
					JOptionPane.showMessageDialog(null, msg,
							Resources.getValue("compile.title"), JOptionPane.ERROR_MESSAGE);
				}
				
			} else {
				
				this.loadAndSetNewHamster();

				//TODO angepasst...
				if(TDDFrameworkContainer.getTDDFramework() != null) {
					
					TDDFrameworkContainer.getTDDFramework().save();
					success = TDDFrameworkContainer.getTDDFramework().compile(ProgramManager.CLASS_NAME);
					
					if(success) {

						this.getCompiledState().setCompiled(true);
						
						return true;
					}
					
					return false;
				}
				//----------------
				
				return true;
			}
			
		} catch (FileNotFoundException exc) {
			exc.printStackTrace();
			
			JOptionPane.showMessageDialog(null, exc.toString(),
					Resources.getValue("compile.title"), JOptionPane.ERROR_MESSAGE);
			
		} catch (IOException exc) {
			exc.printStackTrace();
			
			JOptionPane.showMessageDialog(null, exc.toString(),
					Resources.getValue("compile.title"), JOptionPane.ERROR_MESSAGE);
		}
		
		return false;
	}

	public void loadAndSetNewHamster() {
		try {
			File currentDir = ProgramManager.getProgramManager().getProgram().getDirectory();
			File hamsterProgramPath = new File(currentDir.getAbsolutePath()
					+ File.separatorChar);
			
			URL[] urls = new URL[] { hamsterProgramPath.toURI().toURL() };
			this.classLoader = new URLClassLoader(urls);
			this.classLoader.loadClass(ProgramManager.CLASS_NAME).newInstance();
			
		} catch (MalformedURLException e) {
			e.printStackTrace();

			JOptionPane.showMessageDialog(null, e.toString(),
					Resources.getValue("compile.title"), JOptionPane.ERROR_MESSAGE);
			
		} catch (InstantiationException e) {
			e.printStackTrace();

			JOptionPane.showMessageDialog(null, e.toString(),
					Resources.getValue("compile.title"), JOptionPane.ERROR_MESSAGE);
			
		} catch (IllegalAccessException e) {
			e.printStackTrace();

			JOptionPane.showMessageDialog(null, e.toString(),
					Resources.getValue("compile.title"), JOptionPane.ERROR_MESSAGE);
			
		} catch (ClassNotFoundException e) {
			e.printStackTrace();

			JOptionPane.showMessageDialog(null, e.toString(),
					Resources.getValue("compile.title"), JOptionPane.ERROR_MESSAGE);
			
		}
	}

	@Override
	public JavaFileObject createJavaFileObject(String source, String className, File directory) {
	
		FileWriter fw = null;
		
		try {
			
			File file = new File(directory.getAbsolutePath() + File.separator + className + ".java");
			fw = new FileWriter(file);
			
			fw.write(source);
			fw.flush();
			
			JavaCompiler javac = ToolProvider.getSystemJavaCompiler();
			StandardJavaFileManager fileManager = javac.getStandardFileManager(null, null, null);
			
			Iterable<? extends JavaFileObject> javaFileObjects = fileManager.getJavaFileObjects(file);
			
			if(javaFileObjects.iterator().hasNext()) {
				
				return javaFileObjects.iterator().next();
			}
			
		} catch (IOException exc) {
			
			exc.printStackTrace();

			JOptionPane.showMessageDialog(null, exc.toString(),
					Resources.getValue("compile.title"), JOptionPane.ERROR_MESSAGE);
			
		} finally {
			
			if (fw != null) {
				
				try {
					
					fw.close();
					
				} catch (IOException e) {
					
					e.printStackTrace();
				}
			}
		}
		
		return null;
	}

	@Override
	public boolean compile(JavaFileObject javaFileObject, File[] classPaths, ICompileErrorFixer compileErrorFixer) {
	
		JavaCompiler javac = ToolProvider.getSystemJavaCompiler();
		
		List<String> options = new ArrayList<String>();
		
		if(classPaths.length > 0) {
			
			String classPath = null;
			
			for(File file : classPaths) {
				
				if(classPath == null) {
					
					classPath = file.getAbsolutePath();
					
				} else {
					
					classPath += ";" + file.getAbsolutePath();
				}
			}
			
			if(classPath == null) {
				
				classPath = System.getProperty("java.class.path");
				
			} else {
				
				classPath += ";" + System.getProperty("java.class.path");
			}
			
			options.addAll(Arrays.asList("-classpath", classPath));
		}
		
		DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
		
		StringWriter writer = new StringWriter();
		
		CompilationTask task = javac.getTask(writer, null, diagnostics, options, null, Arrays.asList(new JavaFileObject[] {javaFileObject}));
		boolean result = task.call();
		
		if(result) {
			
			return true;
			
		} else {
			
			boolean fixed = true;
			
			if(compileErrorFixer != null) {
				
				JavaFileObject fixedJavaFileObject = compileErrorFixer.fix(diagnostics.getDiagnostics(), javaFileObject);
				
				if(fixedJavaFileObject != null) {
					
					if(!this.compile(fixedJavaFileObject, classPaths, compileErrorFixer)) {
						
						fixed = false;
					}
					
				} else {
					
					fixed = false;
				}
				
			} else {
				
				fixed = false;
			}
			
			if(fixed) {
				
				return true;
			}
			

			StringBuilder builder = new StringBuilder();
			
			for(Diagnostic<?> diagnostic : diagnostics.getDiagnostics()) {
				
				builder.append(diagnostic);
			}
			
			JOptionPane.showMessageDialog(null, builder.toString(), Resources.getValue("compile.title"), JOptionPane.ERROR_MESSAGE);
			
			return false;
		}
	}

	@Override
	public Class<?> loadClass(File[] directories, String className) {
		
		try {
			
			List<URL> urls = new ArrayList<URL>();
			for(File directory : directories) {
				
				urls.add(directory.toURI().toURL());
			}
			
			this.classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
			
			return this.classLoader.loadClass(className);
			
		} catch (Exception e) {
			
			e.printStackTrace();

			JOptionPane.showMessageDialog(null, e.toString(),
					Resources.getValue("compile.title"), JOptionPane.ERROR_MESSAGE);
			
		}
		
		return null;
	}
}
