package controller;



import java.io.File;

import tdd.TDDFramework;
import tdd.interfaces.CompiledState;
import tdd.interfaces.ICompilerManager;
import tdd.interfaces.IProgramManager;
import tdd.interfaces.ISimulationManager;
import tdd.interfaces.IStateManager;
import tdd.interfaces.SimulationState;



public class TDDFrameworkContainer {

	
	
	private static TDDFramework tddFramework;
	
	
	
	public static void initialize(
			ICompilerManager compilerManager, 
			IProgramManager programManager,
			ISimulationManager simulationManager,
			SimulationState simulationState,
			IStateManager stateManager,
			CompiledState compilingState,
			File testClassesDirectory,
			File rootTestsuiteFile,
			File territoryStateDirectory) {
		
		tddFramework = new TDDFramework(compilerManager, programManager, simulationManager, simulationState, stateManager, compilingState);
		tddFramework.initialize(testClassesDirectory, rootTestsuiteFile, territoryStateDirectory);
	}
	
	public static TDDFramework getTDDFramework() {
		
		return tddFramework;
	}
}
