package controller;



import java.io.File;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

import util.Resources;
import view.ProgramDialog;
import controller.program.ProgramManager;
import controller.program.WorkspaceController;



public class HamsterSimulator {
	
	
	
	
	
	public static void main(String[] args) {
		
		if (!checkJDK()) {
			JOptionPane.showMessageDialog(null, "Sie führen den TDD-Hamster-Simulator mit einem JRE aus.\n" +
		"Voraussetzung ist aber die Ausführung mit einem JDK (siehe Handbuch)!.");
			System.exit(0);
		}
		
		Resources.init();
		
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				
				WorkspaceController.getInstance().initialize(new File("workspace"));
				
				ProgramDialog dialog = new ProgramDialog();
				dialog.setVisible(true);
				
				if(dialog.isCommited()) {
					
					ProgramManager.initialize(dialog.getProgram());
					ProgramManager.getProgramManager().openProgram(dialog.getProgram());
					
				} else {
					
					System.exit(0);
				}
			}
		});
	}
	
	static boolean checkJDK() {
		JavaCompiler javac = ToolProvider.getSystemJavaCompiler();
		return javac != null;
	}
}
