


import tdd.annotations.Test;
import tdd.annotations.Einrichtung;
import tdd.models.TerritoryStates;
import tdd.controllers.TerritoryStateController;
import tdd.errors.TerritoriumErreichtErwartungError;
import tdd.errors.KeinTerritoriumErwartetError;
import tdd.errors.TerritoriumGleichErwartungError;
import tdd.errors.BlacklistTerritoriumError;
import util.Observer;



public class TesteEineStufe extends BaseTest {
	
	
	
	private int counter = 0;
	private String[] territories = new String[1];
	private String[] blacklist = new String[0];
	
	
	
	public TesteEineStufe(TerritoryStateController territoryStateController) {
	
		super(territoryStateController);
				
		territories[0] = "tests laufeStufen TesteEineStufe 2";

		
		
	}
	
	
	
	@Einrichtung()
	public void setup() {
	
		ladeTerritorium("tests laufeStufen TesteEineStufe 1");
		
		this.addObserver(this.hamsterObserver);
	}
	
	@Test()
	public void testeTerritoriumCheckpoints() {

		try {
		
			laufeStufen(1);
		
		} catch(Exception e) {

			throw e;
			
		} finally {
		
			this.deleteObserver(this.hamsterObserver);
		}
	
		if(counter != territories.length) {
		
			throw new TerritoriumErreichtErwartungError();
		}
	}
	
	
	
	private void testeNaechstesTerritorium() {
	
		if(counter < territories.length) {
			
			try {
			
				erwarteTerritoriumGleich(territories[counter]);
				counter++;
			
			} catch (TerritoriumGleichErwartungError e) {}
		}
	}
	
	private void testeBlacklist() {
	
		for(int i=0; i<blacklist.length; i++) {
		
			try {
		
				erwarteTerritoriumGleich(blacklist[i]);
				
				throw new BlacklistTerritoriumError(blacklist[i]);
			
			} catch (TerritoriumGleichErwartungError e) {}
		}
	}
	
	private final Observer hamsterObserver = new Observer() {
	
		public void update() {
		
			testeNaechstesTerritorium();
			testeBlacklist();
		}
	};
}