


import tdd.annotations.Test;
import tdd.annotations.Einrichtung;
import tdd.models.TerritoryStates;
import tdd.controllers.TerritoryStateController;
import tdd.errors.TerritoriumErreichtErwartungError;
import tdd.errors.KeinTerritoriumErwartetError;
import tdd.errors.TerritoriumGleichErwartungError;
import tdd.errors.BlacklistTerritoriumError;
import util.Observer;



public class TesteDreiStufen extends BaseTest {
	
	
	
	private int counter = 0;
	private String[] territories = new String[3];
	private String[] blacklist = new String[1];
	
	
	
	public TesteDreiStufen(TerritoryStateController territoryStateController) {
	
		super(territoryStateController);
				
		territories[0] = "tests laufeStufen TesteDreiStufen 2";
territories[1] = "tests laufeStufen TesteDreiStufen 3";
territories[2] = "tests laufeStufen TesteDreiStufen 4";

		
		blacklist[0] = "tests laufeStufen TesteDreiStufen 5";

	}
	
	
	
	@Einrichtung()
	public void setup() {
	
		ladeTerritorium("tests laufeStufen TesteDreiStufen 1");
		
		this.addObserver(this.hamsterObserver);
	}
	
	@Test()
	public void testeTerritoriumCheckpoints() {

		try {
		
			laufeStufen(3);
		
		} catch(Exception e) {

			throw e;
			
		} finally {
		
			this.deleteObserver(this.hamsterObserver);
		}
	
		if(counter != territories.length) {
		
			throw new TerritoriumErreichtErwartungError();
		}
	}
	
	
	
	private void testeNaechstesTerritorium() {
	
		if(counter < territories.length) {
			
			try {
			
				erwarteTerritoriumGleich(territories[counter]);
				counter++;
			
			} catch (TerritoriumGleichErwartungError e) {}
		}
	}
	
	private void testeBlacklist() {
	
		for(int i=0; i<blacklist.length; i++) {
		
			try {
		
				erwarteTerritoriumGleich(blacklist[i]);
				
				throw new BlacklistTerritoriumError(blacklist[i]);
			
			} catch (TerritoriumGleichErwartungError e) {}
		}
	}
	
	private final Observer hamsterObserver = new Observer() {
	
		public void update() {
		
			testeNaechstesTerritorium();
			testeBlacklist();
		}
	};
}