


import tdd.annotations.Test;
import tdd.annotations.Einrichtung;
import tdd.controllers.TerritoryStateController;
import tdd.errors.TerritoriumErreichtErwartungError;
import tdd.errors.KeinTerritoriumErwartetError;
import util.Observer;



public class TesteNormalfall extends BaseTest {
	
	
	
	private int counter = 0;
	private String[] territories = new String[6];
	
	
	
	public TesteNormalfall(TerritoryStateController territoryStateController) {
	
		super(territoryStateController);
		
		territories[0] = "tests laufeStufe TesteNormalfall 2";
territories[1] = "tests laufeStufe TesteNormalfall 3";
territories[2] = "tests laufeStufe TesteNormalfall 4";
territories[3] = "tests laufeStufe TesteNormalfall 5";
territories[4] = "tests laufeStufe TesteNormalfall 6";
territories[5] = "tests laufeStufe TesteNormalfall 7";

	}
	
	
	
	@Einrichtung()
	public void setup() {
	
		ladeTerritorium("tests laufeStufe TesteNormalfall 1");
		
		this.addObserver(this.hamsterObserver);
	}
	
	@Test()
	public void testeTerritoriumFolge() {

		try {
		
			laufeStufe();
		
		} catch(Exception e) {

			throw e;
			
		} finally {
		
			this.deleteObserver(this.hamsterObserver);
		}
	
		if(counter != territories.length) {
		
			throw new TerritoriumErreichtErwartungError();
		}
	}
	
	
	
	private void testeNaechstesTerritorium() {
	
		if(counter >= territories.length) {
			
			throw new KeinTerritoriumErwartetError();
		}
		
		erwarteTerritoriumGleich(territories[counter]);
		counter++;
	}
	
	private final Observer hamsterObserver = new Observer() {
	
		public void update() {
		
			testeNaechstesTerritorium();
		}
	};
}