


import tdd.annotations.Test;
import tdd.annotations.Einrichtung;
import tdd.controllers.TerritoryStateController;
import tdd.errors.TerritoriumErreichtErwartungError;
import tdd.errors.KeinTerritoriumErwartetError;
import util.Observer;



public class TesteKeineStufeVorhanden extends BaseTest {
	
	
	
	private int counter = 0;
	private String[] territories = new String[10];
	
	
	
	public TesteKeineStufeVorhanden(TerritoryStateController territoryStateController) {
	
		super(territoryStateController);
		
		territories[0] = "tests laufeStufe TesteKeineStufeVorhanden 2";
territories[1] = "tests laufeStufe TesteKeineStufeVorhanden 3";
territories[2] = "tests laufeStufe TesteKeineStufeVorhanden 4";
territories[3] = "tests laufeStufe TesteKeineStufeVorhanden 5";
territories[4] = "tests laufeStufe TesteKeineStufeVorhanden 6";
territories[5] = "tests laufeStufe TesteKeineStufeVorhanden 7";
territories[6] = "tests laufeStufe TesteKeineStufeVorhanden 8";
territories[7] = "tests laufeStufe TesteKeineStufeVorhanden 9";
territories[8] = "tests laufeStufe TesteKeineStufeVorhanden 10";
territories[9] = "tests laufeStufe TesteKeineStufeVorhanden 11";

	}
	
	
	
	@Einrichtung()
	public void setup() {
	
		ladeTerritorium("tests laufeStufe TesteKeineStufeVorhanden 1");
		
		this.addObserver(this.hamsterObserver);
	}
	
	@Test()
	public void testeTerritoriumFolge() {

		try {
		
			laufeStufe();
		
		} catch(Exception e) {

			throw e;
			
		} finally {
		
			this.deleteObserver(this.hamsterObserver);
		}
	
		if(counter != territories.length) {
		
			throw new TerritoriumErreichtErwartungError();
		}
	}
	
	
	
	private void testeNaechstesTerritorium() {
	
		if(counter >= territories.length) {
			
			throw new KeinTerritoriumErwartetError();
		}
		
		erwarteTerritoriumGleich(territories[counter]);
		counter++;
	}
	
	private final Observer hamsterObserver = new Observer() {
	
		public void update() {
		
			testeNaechstesTerritorium();
		}
	};
}