


import tdd.annotations.Test;
import tdd.annotations.Einrichtung;
import tdd.controllers.TerritoryStateController;
import tdd.errors.TerritoriumErreichtErwartungError;
import tdd.errors.KeinTerritoriumErwartetError;
import util.Observer;



public class TesteDeckeNiedrig extends BaseTest {
	
	
	
	private int counter = 0;
	private String[] territories = new String[4];
	
	
	
	public TesteDeckeNiedrig(TerritoryStateController territoryStateController) {
	
		super(territoryStateController);
		
		territories[0] = "tests laufeStufe TesteDeckeNiedrig 2";
territories[1] = "tests laufeStufe TesteDeckeNiedrig 3";
territories[2] = "tests laufeStufe TesteDeckeNiedrig 4";
territories[3] = "tests laufeStufe TesteDeckeNiedrig 5";

	}
	
	
	
	@Einrichtung()
	public void setup() {
	
		ladeTerritorium("tests laufeStufe TesteDeckeNiedrig 1");
		
		this.addObserver(this.hamsterObserver);
	}
	
	@Test()
	public void testeTerritoriumFolge() {

		try {
		
			laufeStufe();
		
		} catch(Exception e) {

			throw e;
			
		} finally {
		
			this.deleteObserver(this.hamsterObserver);
		}
	
		if(counter != territories.length) {
		
			throw new TerritoriumErreichtErwartungError();
		}
	}
	
	
	
	private void testeNaechstesTerritorium() {
	
		if(counter >= territories.length) {
			
			throw new KeinTerritoriumErwartetError();
		}
		
		erwarteTerritoriumGleich(territories[counter]);
		counter++;
	}
	
	private final Observer hamsterObserver = new Observer() {
	
		public void update() {
		
			testeNaechstesTerritorium();
		}
	};
}