import {calculateGridSize, initCanvas, initHamster, loadPage} from "./canvas.js";
import {setWebsiteContentInUserLanguage} from "./language.js";
import {initButtons} from "./buttons.js";
import {initDialogs} from "./dialogs.js";
import {initMenu} from "./navigation.js";
import {saveTemporaryTerritory} from "./saveAndLoad.js";


document.addEventListener('DOMContentLoaded',  init);

/**
 * Initialisiert alle Funktionen und Variablen, nachdem die Webseite geladen wurde.
 */
function init() {
    setWebsiteContentInUserLanguage();
    loadPage();
    initDialogs();
    initMenu();
    initButtons();
    calculateGridSize();
    initCanvas();
    initHamster();
    saveTemporaryTerritory();
}