/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
      "./index.html",
      "./scripts/**/*.js"
  ],
  theme: {
    extend: {
      colors: {
        'default-theme': '#ffffff',
        'default-theme-text': '#708',
        'default-theme-var': '#000000',
        'basic-dark': '#2E3235',
        'basic-dark-text': '#fda331',
        'basic-dark-var': '#6fb3d2',
        'basic-light': '#ffffff',
        'basic-light-text': '#5e81ac',
        'basic-light-var': '#d08770',
        'gruvbox-dark': '#282828',
        'gruvbox-dark-text': '#fb4934',
        'gruvbox-dark-var': '#83a598',
        'gruvbox-light': '#fbf1c7',
        'gruvbox-light-text': '#9d0006',
        'gruvbox-light-var': '#076678',
        'material-dark': '#2e3235',
        'material-dark-text': '#cf6edf',
        'material-dark-var': '#bdbdbd',
        'nord': '#2e3440',
        'nord-text': '#5e81ac',
        'nord-var': '#8fbcbb',
        'solarized-dark': '#002b36',
        'solarized-dark-text': '#859900',
        'solarized-dark-var': '#93a1a1',
        'solarized-light': '#fdf6e3',
        'solarized-light-text': '#859900',
        'solarized-light-var': '#268bd2',
      },
      screens: {
        'desktop': '1920px',
        // => @media (min-width: 1920px)
      },
      backgroundImage: (theme) => ({
        'background': "url('./img/bg.jpg')",
      }),
      gridTemplateRows: {
        'layout': '50px repeat(1, minmax(0, 1fr))'
      },
      keyframes: {
        'open-menu-sm': {
          '0%': { transform: 'scaleY(0)' },
          '80%': { transform: 'scaleY(1.2)' },
          '100%': { transform: 'scaleY(1)' },
        },
        'open-menu-lg': {
          '0%': { transform: 'scaleX(0)' },
          '80%': { transform: 'scaleX(1.2)' },
          '100%': { transform: 'scaleX(1)' },
        },
      },
      animation: {
        'open-menu-sm': 'open-menu-sm 0.5s ease-in-out forwards',
        'open-menu-lg': 'open-menu-lg 0.5s ease-in-out forwards',
      },
    },
  },
  plugins: [],
}

