export let userLanguage = 'de';
export let languagesStrings = {
    'de': {
        'hamster-direction-north': 'Norden',
        'hamster-direction-west': 'West',
        'hamster-direction-east': 'Osten',
        'hamster-direction-south': 'Süden',
        'textEditor': '// Schreibe dein Hamster-Programm.. :)\n',
        'id-heading': 'Online Hamster Simulator für JavaScript',
        'id-heading-img': 'Bilde eines Hamsters',
        'id-save-Files': 'Dateien speichern',
        'id-load-Files': 'Dateien laden',
        'id-change-language': 'Sprache ändern',
        'id-language-german-link': 'Deutsch',
        'id-language-english-link': 'Englisch',
        'id-editor-settings': 'Texteditor Einstellungen',
        'id-change-font-size': 'Schriftgröße ändern',
        'id-change-theme': 'Design ändern',
        'id-auto-completion-link': 'Automatische Textvervollständigung',
        'id-play-button': 'Programm starten',
        'id-play-button-img': 'Button zum Starten des Programms',
        'id-pause-button': 'Programm pausieren',
        'id-pause-button-img': 'Button zum Pausieren des Programms',
        'id-stop-button': 'Programm stoppen',
        'id-stop-button-img': 'Button zum Stoppen des Programms',
        'id-reset-button': 'Territorium zurücksetzen',
        'id-reset-button-img': 'Button zum Zurücksetzen des Territoriums',
        'id-info-button': 'Informationen über Territorium',
        'id-info-button-img': 'Button zum Anzeigen von Informationen über das Territorium',
        'id-grain-button': 'Körner im Territorium platzieren',
        'id-grain-button-img': 'Button zum Platzieren von Körnern innerhalb des Territoriums',
        'id-wall-button': 'Mauer im Territorium platzieren',
        'id-wall-button-img': 'Button zum Platzieren von Mauern innerhalb des Territoriums',
        'id-delete-button': 'Elemente im Territorium löschen',
        'id-delete-button-img': 'Button zum Löschen von Elementen innerhalb des Territoriums',
        'id-give-hamster-grains-button': 'Platziere Körner im Maul des Hamsters',
        'id-give-hamster-grains-button-img': 'Button zum Platzieren von Körnern im Maul des Standard-Hamsters',
        'id-change-hamster-direction-button': 'Hamster nach links drehen',
        'id-change-hamster-direction-button-img': 'Button um den Standard-Hamster nach links zu drehen',
        'id-change-size-button': 'Territorium Größe ändern',
        'id-change-size-button-img': 'Button zum Ändern der Territorium-Größe',
        'id-info-button-grains-in-territory': 'Körner im Feld:',
        'id-info-button-grains-in-mouth': 'Körner im Maul:',
        'id-info-button-grains-hamster-direction': 'Blickrichtung:',
        'id-change-size-dialog-heading': 'Größe des Territoriums ändern:',
        'id-change-size-dialog-row-input': 'Reihen',
        'id-row-input': 'Reihenanzahl',
        'id-change-size-dialog-col-input': 'Spalten',
        'id-col-input': 'Spaltenanzahl',
        'id-change-size-dialog-cancel-button': 'Abbrechen',
        'id-add-grains-territory-heading': 'Wie viele Körner sollen auf dem Feld liegen?',
        'id-add-grains-territory-dialog-input-label': 'Anzahl Körner',
        'id-add-grains-territory-dialog-input': 'Anzahl der Körner',
        'id-add-grains-territory-dialog-cancel-button': 'Abbrechen',
        'id-add-grains-hamster-dialog-heading': 'Wie viele Körner soll der Hamster im Maul haben?',
        'id-add-grains-hamster-dialog-input-label': 'Anzahl Körner',
        'id-add-grains-hamster-dialog-input': 'Anzahl der Körner',
        'id-add-grains-hamster-dialog-cancel-button': 'Abbrechen',
        'id-read-number-text': 'Welche Zahl soll der Hamster lesen?',
        'id-read-number-dialog-input-label': 'Zahl',
        'id-read-number-input': 'Zahl, die gelesen werden soll',
        'id-read-string-text': 'Welche Zeichenkette soll der Hamster lesen?',
        'id-read-string-dialog-input-label': 'Zeichenkette',
        'id-read-string-input': 'Zeichenkette, die gelesen werden soll',
        'id-write-string-text': 'Der Hamster möchte dir folgendes mitteilen:',
        'id-write-string-output': 'Zeichenkette, die der Hamster ausgibt',
        'id-error-dialog-heading': 'Fehler',
        'id-error-output': 'Folgender Fehler ist aufgetreten',
        'id-save-files-dialog-heading': 'Dateien speichern',
        'id-save-all-label': 'Alles',
        'id-save-editor-label': 'Editor',
        'id-save-territory-label': 'Territorium',
        'id-save-files-dialog-save-button': 'Speichern',
        'id-save-files-dialog-cancel-button': 'Abbrechen',
        'id-change-font-size-dialog-heading': 'Wähle ein Schriftgröße zwischen 8px und 50px:',
        'id-font-size-input': 'Neue Schriftgröße in px',
        'id-change-font-size-dialog-cancel-button': 'Abbrechen',
        'id-change-theme-dialog-heading': 'Wähle ein Design:',
        'id-change-theme-dialog-cancel-button': 'Abbrechen',
        'error-to-many-hamster': 'Es existieren schon zu viele Hamster!',
        'error-wrong-parameter': 'Der Hamster kennt diese Parameter nicht!',
        'error-hamster-init': 'Der Hamster ist nicht initialisiert!',
        'error-wall': 'Der Hamster kann nicht gegen eine Mauer oder aus dem Territorium laufen!',
        'error-empty-cell': 'Die Kachel ist leer!',
        'error-empty-mouth': 'Das Maul des Hamsters ist leer!',
        'error-unknown': 'Ein unerwarteter Fehler ist aufgetreten! Bitte lade die Seite neu!',
        'error-hamster-placement': 'Der Hamster kann nicht auf einer Mauer oder außerhalb des Territoriums platziert werden!',
        'error-code-execution': 'Fehler beim Ausführen des Codes. ' +
            'Bitte überprüfe, ob alle Variablen korrekt initialisiert sind und die aufgerufenen Funktionen/Methoden auch wirklich existieren! ' +
            'Die genaue Fehlermeldung lautet: ',
        'error-code-transform': 'Fehlerhafte Eingabe. ' +
            'Bitte überprüfe die Syntax und Variablenbelegung des Programmcodes. ' +
            'Die genaue Fehlermeldung lautet: ',
        'error-file': 'Fehler beim Laden der Datei. ' +
            'Möglicherweise ist die Datei kaputt.',
        'error-replace-instructions': 'Fehler beim Übersetzen der Anweisungen. '+
            'Bitte stelle sicher, dass nur gültige Hamster-Befehle und die korrekte Syntax verwendet werden.',
        'error-function-names': 'Die Basis-Hamster-Funktionen können nicht überschrieben werden! ' +
            'Bitte überprüfe die Namen der erstellten Funktionen.',
    },
    'en': {
        'hamster-direction-north': 'north',
        'hamster-direction-west': 'west',
        'hamster-direction-east': 'east',
        'hamster-direction-south': 'south',
        'textEditor': '// Write your hamster-program.. :)\n',
        'id-heading': 'Online Hamster Simulator for JavaScript',
        'id-heading-img': 'Image of a hamster',
        'id-save-Files': 'Save files',
        'id-load-Files': 'Load files',
        'id-change-language': 'Change language',
        'id-language-german-link': 'German',
        'id-language-english-link': 'English',
        'id-editor-settings': 'Texteditor settings',
        'id-change-font-size': 'Change font size',
        'id-change-theme': 'Change design',
        'id-auto-completion-link': 'Autocompletion',
        'id-play-button': 'Start program',
        'id-play-button-img': 'Button zum Starten des Programms',
        'id-pause-button': 'Pause program',
        'id-pause-button-img': 'Button zum Pausieren des Programms',
        'id-stop-button': 'Stop program',
        'id-stop-button-img': 'Button zum Stoppen des Programms',
        'id-reset-button': 'Reset territory',
        'id-reset-button-img': 'Button zum Zurücksetzen des Territoriums',
        'id-info-button': 'Information about territory',
        'id-info-button-img': 'Button for displaying information about the territory',
        'id-grain-button': 'Place grains in the territory',
        'id-grain-button-img': 'Button for placing grains within the territory',
        'id-wall-button': 'Place walls in the territory',
        'id-wall-button-img': 'Button for placing walls within the territory',
        'id-delete-button': 'Delete elements within the territory',
        'id-delete-button-img': 'Button for deleting elements within the territory',
        'id-give-hamster-grains-button': 'Place grains in the hamster\'s mouth',
        'id-give-hamster-grains-button-img': 'Button for placing grains in the mouth of the default hamster',
        'id-change-hamster-direction-button': 'Turn hamster left',
        'id-change-hamster-direction-button-img': 'Button to turn the standard hamster to the left',
        'id-change-size-button': 'Change the size of the territory',
        'id-change-size-button-img': 'Button to change the territory size',
        'id-info-button-grains-in-territory': 'Grains in field:',
        'id-info-button-grains-in-mouth': 'Grains in mouth:',
        'id-info-button-grains-hamster-direction': 'Hamster direction:',
        'id-change-size-dialog-heading': 'Change the size of the territory:',
        'id-change-size-dialog-row-input': 'Rows',
        'id-row-input': 'Number of rows',
        'id-change-size-dialog-col-input': 'Columns',
        'id-col-input': 'Number of columns',
        'id-change-size-dialog-cancel-button': 'Cancel',
        'id-add-grains-territory-heading': 'How many grains should there be in the field?',
        'id-add-grains-territory-dialog-input-label': 'Number of grains',
        'id-add-grains-territory-dialog-input': 'Number of grains',
        'id-add-grains-territory-dialog-cancel-button': 'Cancel',
        'id-add-grains-hamster-dialog-heading': 'How many grains should the hamster have in its mouth?',
        'id-add-grains-hamster-dialog-input-label': 'Number of grains',
        'id-add-grains-hamster-dialog-input': 'Number of grains',
        'id-add-grains-hamster-dialog-cancel-button': 'Cancel',
        'id-read-number-text': 'Which number should the hamster read?',
        'id-read-number-dialog-input-label': 'Number',
        'id-read-number-input': 'Number to be read',
        'id-read-string-text': 'Which string should the hamster read?',
        'id-read-string-dialog-input-label': 'String',
        'id-read-string-input': 'String to be read',
        'id-write-string-text': 'The hamster would like to tell you the following:',
        'id-write-string-output': 'String output by the hamster',
        'id-error-dialog-heading': 'Error',
        'id-error-output': 'The following error has occurred',
        'id-save-files-dialog-heading': 'Save files',
        'id-save-all-label': 'All',
        'id-save-editor-label': 'Editor',
        'id-save-territory-label': 'Territory',
        'id-save-files-dialog-save-button': 'Save',
        'id-save-files-dialog-cancel-button': 'Cancel',
        'id-change-font-size-dialog-heading': 'Choose a font size between 8px and 50px:',
        'id-font-size-input': 'New font size in px',
        'id-change-font-size-dialog-cancel-button': 'Cancel',
        'id-change-theme-dialog-heading': 'Choose a design:',
        'id-change-theme-dialog-cancel-button': 'Cancel',
        'error-to-many-hamster': 'There are already too many hamsters!',
        'error-wrong-parameter': 'The hamster does not know these parameters!',
        'error-hamster-init': 'The hamster has not been initialized!',
        'error-wall': 'The hamster cannot run into a wall or out of the territory!',
        'error-empty-cell': 'The tile is empty!',
        'error-empty-mouth': 'The hamster\'s mouth is empty!',
        'error-unknown': 'An unexpected error has occurred! Please reload the page!',
        'error-hamster-placement': 'The hamster cannot be placed on a wall or outside the territory!',
        'error-code-execution': 'Error while executing the code. ' +
            'Please check whether all variables are correctly initialized and the called functions/methods really exist! ' +
            'The exact error message is: ',
        'error-code-transform': 'Incorrect input. ' +
            'Please check the syntax and variable assignment of the program code. ' +
            'The exact error message is: ',
        'error-file': 'Error while loading the file. ' +
            'The file may be corrupt.',
        'error-replace-instructions': 'Error while translating the instructions. ' +
            'Please make sure that only valid hamster commands and the correct syntax are used.',
        'error-function-names': 'The basic hamster functions cannot be overwritten! ' +
            'Please check the names of the created functions.',
    }
}

/**
 * Lädt die im Browser des Nutzers bevorzugte Sprache.
 * 
 * Wird die Sprache nicht unterstützt, wird Deutsch als Standard ausgewählt.
 */
function loadUserLanguage() {
    let userLang = navigator.languages ? navigator.languages[0] : navigator.language;
    userLanguage = userLang.substring(0, 2);

    if (!userLanguage in languagesStrings) {
        userLanguage = 'de';
    }
}

/**
 * Setzt für alle Elemente im Projekt den Text entsprechend der eingestellten Sprache des Nutzers.
 */
export function setWebsiteContentInUserLanguage() {
    document.getElementById('heading').innerText = languagesStrings[userLanguage]['id-heading'];
    document.getElementById('heading-img').alt = languagesStrings[userLanguage]['id-heading-img'];
    document.getElementById('save-Files').innerText = languagesStrings[userLanguage]['id-save-Files'];
    document.getElementById('load-Files').innerText = languagesStrings[userLanguage]['id-load-Files'];
    document.getElementById('change-language').innerText = languagesStrings[userLanguage]['id-change-language'];
    document.getElementById('language-german-link').innerText = languagesStrings[userLanguage]['id-language-german-link'];
    document.getElementById('language-english-link').innerText = languagesStrings[userLanguage]['id-language-english-link'];
    document.getElementById('editor-settings').innerText = languagesStrings[userLanguage]['id-editor-settings'];
    document.getElementById('change-font-size').innerText = languagesStrings[userLanguage]['id-change-font-size'];
    document.getElementById('change-theme').innerText = languagesStrings[userLanguage]['id-change-theme'];
    document.getElementById('auto-completion-link').innerText = languagesStrings[userLanguage]['id-auto-completion-link'];
    document.getElementById('play-button').title = languagesStrings[userLanguage]['id-play-button'];
    document.getElementById('play-button-img').alt = languagesStrings[userLanguage]['id-play-button-img'];
    document.getElementById('pause-button').title = languagesStrings[userLanguage]['id-pause-button'];
    document.getElementById('pause-button-img').alt = languagesStrings[userLanguage]['id-pause-button-img'];
    document.getElementById('stop-button').title = languagesStrings[userLanguage]['id-stop-button'];
    document.getElementById('stop-button-img').alt = languagesStrings[userLanguage]['id-stop-button-img'];
    document.getElementById('reset-button').title = languagesStrings[userLanguage]['id-reset-button'];
    document.getElementById('reset-button-img').alt = languagesStrings[userLanguage]['id-reset-button-img'];
    document.getElementById('info-button').title = languagesStrings[userLanguage]['id-info-button'];
    document.getElementById('info-button-img').alt = languagesStrings[userLanguage]['id-info-button-img'];
    document.getElementById('grain-button').title = languagesStrings[userLanguage]['id-grain-button'];
    document.getElementById('grain-button-img').alt = languagesStrings[userLanguage]['id-grain-button-img'];
    document.getElementById('wall-button').title = languagesStrings[userLanguage]['id-wall-button'];
    document.getElementById('wall-button-img').alt = languagesStrings[userLanguage]['id-wall-button-img'];
    document.getElementById('delete-button').title = languagesStrings[userLanguage]['id-delete-button'];
    document.getElementById('delete-button-img').alt = languagesStrings[userLanguage]['id-delete-button-img'];
    document.getElementById('give-hamster-grains-button').title = languagesStrings[userLanguage]['id-give-hamster-grains-button'];
    document.getElementById('give-hamster-grains-button-img').alt = languagesStrings[userLanguage]['id-give-hamster-grains-button-img'];
    document.getElementById('change-hamster-direction-button').title = languagesStrings[userLanguage]['id-change-hamster-direction-button'];
    document.getElementById('change-hamster-direction-button-img').alt = languagesStrings[userLanguage]['id-change-hamster-direction-button-img'];
    document.getElementById('change-size-button').title = languagesStrings[userLanguage]['id-change-size-button'];
    document.getElementById('change-size-button-img').alt = languagesStrings[userLanguage]['id-change-size-button-img'];
    document.getElementById('info-button-grains-in-territory').innerText = languagesStrings[userLanguage]['id-info-button-grains-in-territory'];
    document.getElementById('info-button-grains-in-mouth').innerText = languagesStrings[userLanguage]['id-info-button-grains-in-mouth'];
    document.getElementById('info-button-hamster-direction').innerText = languagesStrings[userLanguage]['id-info-button-grains-hamster-direction'];
    document.getElementById('change-size-dialog-heading').innerText = languagesStrings[userLanguage]['id-change-size-dialog-heading'];
    document.getElementById('change-size-dialog-row-input').innerText = languagesStrings[userLanguage]['id-change-size-dialog-row-input'];
    document.getElementById('row-input').title = languagesStrings[userLanguage]['id-row-input'];
    document.getElementById('change-size-dialog-col-input').innerText = languagesStrings[userLanguage]['id-change-size-dialog-col-input'];
    document.getElementById('col-input').title = languagesStrings[userLanguage]['id-col-input'];
    document.getElementById('change-size-dialog-cancel-button').value = languagesStrings[userLanguage]['id-change-font-size-dialog-cancel-button'];
    document.getElementById('add-grains-territory-dialog-heading').innerText = languagesStrings[userLanguage]['id-add-grains-territory-heading'];
    document.getElementById('add-grains-territory-dialog-input-label').innerText = languagesStrings[userLanguage]['id-add-grains-territory-dialog-input-label'];
    document.getElementById('number-of-grains-territory-input').title = languagesStrings[userLanguage]['id-add-grains-territory-dialog-input'];
    document.getElementById('add-grains-territory-dialog-cancel-button').value = languagesStrings[userLanguage]['id-add-grains-territory-dialog-cancel-button'];
    document.getElementById('add-grains-hamster-dialog-heading').innerText = languagesStrings[userLanguage]['id-add-grains-hamster-dialog-heading'];
    document.getElementById('add-grains-hamster-dialog-input-label').innerText = languagesStrings[userLanguage]['id-add-grains-hamster-dialog-input-label'];
    document.getElementById('number-of-grains-hamster-input').title = languagesStrings[userLanguage]['id-add-grains-hamster-dialog-input'];
    document.getElementById('add-grains-hamster-dialog-cancel-button').value = languagesStrings[userLanguage]['id-add-grains-hamster-dialog-cancel-button'];
    document.getElementById('read-number-text').innerText = languagesStrings[userLanguage]['id-read-number-text'];
    document.getElementById('read-number-dialog-input-label').innerText = languagesStrings[userLanguage]['id-read-number-dialog-input-label'];
    document.getElementById('read-number-input').title = languagesStrings[userLanguage]['id-read-number-input'];
    document.getElementById('read-string-text').innerText = languagesStrings[userLanguage]['id-read-string-text'];
    document.getElementById('read-string-dialog-input-label').innerText = languagesStrings[userLanguage]['id-read-string-dialog-input-label'];
    document.getElementById('read-string-input').title = languagesStrings[userLanguage]['id-read-string-input'];
    document.getElementById('write-string-text').innerText = languagesStrings[userLanguage]['id-write-string-text'];
    document.getElementById('write-string-output').title = languagesStrings[userLanguage]['id-write-string-output'];
    document.getElementById('error-dialog-heading').innerText = languagesStrings[userLanguage]['id-error-dialog-heading'];
    document.getElementById('error-output').title = languagesStrings[userLanguage]['id-error-output'];
    document.getElementById('save-files-dialog-heading').innerText = languagesStrings[userLanguage]['id-save-files-dialog-heading'];
    document.getElementById('save-all-label').textContent = languagesStrings[userLanguage]['id-save-all-label'];
    document.getElementById('save-editor-label').textContent = languagesStrings[userLanguage]['id-save-editor-label'];
    document.getElementById('save-territory-label').textContent = languagesStrings[userLanguage]['id-save-territory-label'];
    document.getElementById('save-files-dialog-save-button').value = languagesStrings[userLanguage]['id-save-files-dialog-save-button'];
    document.getElementById('save-files-dialog-cancel-button').value = languagesStrings[userLanguage]['id-save-files-dialog-cancel-button'];
    document.getElementById('change-font-size-dialog-heading').innerText = languagesStrings[userLanguage]['id-change-font-size-dialog-heading'];
    document.getElementById('font-size-input').innerText = languagesStrings[userLanguage]['id-font-size-input'];
    document.getElementById('change-font-size-dialog-cancel-button').value = languagesStrings[userLanguage]['id-change-font-size-dialog-cancel-button'];
    document.getElementById('change-theme-dialog-heading').innerText = languagesStrings[userLanguage]['id-change-theme-dialog-heading'];
    document.getElementById('change-theme-dialog-cancel-button').value = languagesStrings[userLanguage]['id-change-theme-dialog-cancel-button'];
}

/**
 * Setter für das userLanguage-Attribut.
 *
 * @param language, neuer Wert.
 */
export function setUserLanguage(language) {
    userLanguage = language;
}

loadUserLanguage();