package view;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;

import listener.NewClassListener;
import util.ResourceManager;

/**
 * Popup-Menu fr die Ordner im JTree
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class DirectoryPopupMenu extends JPopupMenu {
	
	public DirectoryPopupMenu(JTree tree) {
		super();
		
		JMenuItem newClassMenuItem = new JMenuItem(ResourceManager
				.getResourceManager().getValue("filetree.newsubclass") + " ...");
		newClassMenuItem.addActionListener(new NewClassListener(tree));
		this.add(newClassMenuItem);
	}
}
