package util;

import java.awt.Container;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;

import javax.swing.ImageIcon;

/**
 * Hilfsroutinen zum Laden von Dateien aus dem Unterverzeichnis "resources" der
 * Theater-jar-Datei
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class ResourceLoader {

	static MediaTracker tracker = new MediaTracker(new Container());

	/**
	 * Liefert ein Image aus einer internen Bilddatei des Unterverzeichnisses
	 * "resources" der Theater-jar-Datei
	 * 
	 * @param name
	 * @return
	 */
	public static Image getImage(String name) {
		URL url = ResourceLoader.class.getClassLoader().getResource(
				"resources/" + name);
		Image img = Toolkit.getDefaultToolkit().createImage(url);
		ResourceLoader.tracker.addImage(img, 1);
		try {
			ResourceLoader.tracker.waitForID(1);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		return img;
	}

	/**
	 * Liefert ein ImageIcon aus einer internen Bilddatei des
	 * Unterverzeichnisses "resources" der Theater-jar-Datei
	 * 
	 * @param name
	 * @return
	 */
	public static ImageIcon getImageIcon(String name) {
		return new ImageIcon(ResourceLoader.getImage(name));
	}

	/**
	 * Liefert die URL einer Resourcen-Datei des Unterverzeichnisses "resources"
	 * der Theater-jar-Datei
	 * 
	 * @param name
	 * @return
	 */
	public static URL getFileURL(String name) {
		return ResourceLoader.class.getClassLoader().getResource(
				"resources/" + name);
	}

}
