package util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class JarDemo {

	public static void main(String[] args) {
		if (args.length < 2) {
			System.out.println("Usage: java JarDemo jar-file files...");
			System.exit(1);
		}

		try {
			byte[] buf = new byte[4096];
			JarOutputStream jar = new JarOutputStream(new FileOutputStream(
					args[0]), new Manifest());
			for (int i = 1; i < args.length; ++i) {
				String fname = args[i];
				System.out.println("adding " + fname);
				FileInputStream in = new FileInputStream(fname);
				jar.putNextEntry(new JarEntry(fname));
				int len;
				while ((len = in.read(buf)) > 0) {
					jar.write(buf, 0, len);
				}
				in.close();
			}
			jar.close();
		} catch (Exception exc) {

		}

	}

}
