package simulation.listener;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

import listener.TheaterMouseListener;
import model.Play;
import simulation.SimulationManager;
import theater.Component;
import theater.MouseInfo;
import theater.Stage;
import theater_intern.IComponent;
import theater_intern.IStage;
import util.Utils;
import view.StagePanel;

/**
 * Reagiert auf MouseEvents im Zustand running
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class SimulationMouseListener extends TheaterMouseListener {

	private List<Object> concernedObjects;
	private List<Object> movedObjects;
	private StagePanel stagePanel;
	private IStage iStage;

	public SimulationMouseListener() {
		this.movedObjects = new ArrayList<Object>();
	}

	public void mousePressed(MouseEvent e) {
		SimulationManager simManager = SimulationManager.getSimulationManager();
		this.stagePanel = Play.getPlay().getStagePanel();
		this.stagePanel.requestFocusInWindow();
		this.iStage = Play.getPlay().getActiveStage();
		this.calcConcernedObjects(e);

		MouseInfo mouseInfo = new MouseInfo(e);
		mouseInfo.setColumn(this.stagePanel.getCellColumn(e.getX()));
		mouseInfo.setRow(this.stagePanel.getCellRow(e.getY()));
		for (Object obj : this.concernedObjects) {
			if (Utils.dynInstanceof(obj, IComponent.class)) {
				IComponent iComp = (IComponent) obj;
				Component comp = IComponent.getComp(iComp);
				java.awt.Rectangle rect = this.stagePanel
						.getStageRectangle(iComp);
				mouseInfo.setX(this.stagePanel.getStageX(e.getX()) - rect.x);
				mouseInfo.setY(this.stagePanel.getStageY(e.getY()) - rect.y);
				mouseInfo.setSource(comp);
				simManager.insertEventObject(new MousePressedObject(comp,
						mouseInfo));
			} else if (Utils.dynInstanceof(obj, IStage.class)) {
				IStage iStage = (IStage) obj;
				Stage stage = IStage.getStage(iStage);
				mouseInfo.setX(this.stagePanel.getStageX(e.getX()));
				mouseInfo.setY(this.stagePanel.getStageY(e.getY()));
				mouseInfo.setSource(stage);
				simManager.insertEventObject(new MousePressedObject(stage,
						mouseInfo));
			}
		}
	}

	public void mouseReleased(MouseEvent e) {
		SimulationManager simManager = SimulationManager.getSimulationManager();
		this.stagePanel = Play.getPlay().getStagePanel();
		this.stagePanel.requestFocusInWindow();
		this.iStage = Play.getPlay().getActiveStage();
		this.calcConcernedObjects(e);

		MouseInfo mouseInfo = new MouseInfo(e);
		mouseInfo.setColumn(this.stagePanel.getCellColumn(e.getX()));
		mouseInfo.setRow(this.stagePanel.getCellRow(e.getY()));
		for (Object obj : this.concernedObjects) {
			if (Utils.dynInstanceof(obj, IComponent.class)) {
				IComponent iComp = (IComponent) obj;
				Component comp = IComponent.getComp(iComp);
				java.awt.Rectangle rect = this.stagePanel
						.getStageRectangle(iComp);
				mouseInfo.setX(this.stagePanel.getStageX(e.getX()) - rect.x);
				mouseInfo.setY(this.stagePanel.getStageY(e.getY()) - rect.y);
				mouseInfo.setSource(comp);
				simManager.insertEventObject(new MouseReleasedObject(comp,
						mouseInfo));
			} else if (Utils.dynInstanceof(obj, IStage.class)) {
				IStage iStage = (IStage) obj;
				Stage stage = IStage.getStage(iStage);
				mouseInfo.setX(this.stagePanel.getStageX(e.getX()));
				mouseInfo.setY(this.stagePanel.getStageY(e.getY()));
				mouseInfo.setSource(stage);
				simManager.insertEventObject(new MouseReleasedObject(stage,
						mouseInfo));
			}
		}
	}

	public void mouseClicked(MouseEvent e) {
		// Anmerkung: kann prinzipiell falsch sein, wenn sich eine Komponente in
		// ihrer act- oder run-Methode bewegt; das Event wird generiert, wenn
		// sich beim Loslassen der Mauscursor ber der Komponente befindet
		SimulationManager simManager = SimulationManager.getSimulationManager();
		this.stagePanel = Play.getPlay().getStagePanel();
		this.stagePanel.requestFocusInWindow();
		this.iStage = Play.getPlay().getActiveStage();
		this.calcConcernedObjects(e);

		MouseInfo mouseInfo = new MouseInfo(e);
		mouseInfo.setColumn(this.stagePanel.getCellColumn(e.getX()));
		mouseInfo.setRow(this.stagePanel.getCellRow(e.getY()));
		for (Object obj : this.concernedObjects) {
			if (Utils.dynInstanceof(obj, IComponent.class)) {
				IComponent iComp = (IComponent) obj;
				Component comp = IComponent.getComp(iComp);
				java.awt.Rectangle rect = this.stagePanel
						.getStageRectangle(iComp);
				mouseInfo.setX(this.stagePanel.getStageX(e.getX()) - rect.x);
				mouseInfo.setY(this.stagePanel.getStageY(e.getY()) - rect.y);
				mouseInfo.setSource(comp);
				simManager.insertEventObject(new MouseClickedObject(comp,
						mouseInfo));
			} else if (Utils.dynInstanceof(obj, IStage.class)) {
				IStage iStage = (IStage) obj;
				Stage stage = IStage.getStage(iStage);
				mouseInfo.setX(this.stagePanel.getStageX(e.getX()));
				mouseInfo.setY(this.stagePanel.getStageY(e.getY()));
				mouseInfo.setSource(stage);
				simManager.insertEventObject(new MouseClickedObject(stage,
						mouseInfo));
			}
		}
	}

	public void mouseDragged(MouseEvent e) {
		SimulationManager simManager = SimulationManager.getSimulationManager();
		this.stagePanel = Play.getPlay().getStagePanel();
		this.stagePanel.requestFocusInWindow();
		this.iStage = Play.getPlay().getActiveStage();
		this.calcConcernedObjects(e);

		MouseInfo mouseInfo = new MouseInfo(e);
		mouseInfo.setColumn(this.stagePanel.getCellColumn(e.getX()));
		mouseInfo.setRow(this.stagePanel.getCellRow(e.getY()));
		for (Object obj : this.concernedObjects) {
			if (Utils.dynInstanceof(obj, IComponent.class)) {
				IComponent iComp = (IComponent) obj;
				Component comp = IComponent.getComp(iComp);
				java.awt.Rectangle rect = this.stagePanel
						.getStageRectangle(iComp);
				mouseInfo.setX(this.stagePanel.getStageX(e.getX()) - rect.x);
				mouseInfo.setY(this.stagePanel.getStageY(e.getY()) - rect.y);
				mouseInfo.setSource(comp);
				simManager.insertEventObject(new MouseDraggedObject(comp,
						mouseInfo));
			} else if (Utils.dynInstanceof(obj, IStage.class)) {
				IStage iStage = (IStage) obj;
				Stage stage = IStage.getStage(iStage);
				mouseInfo.setX(this.stagePanel.getStageX(e.getX()));
				mouseInfo.setY(this.stagePanel.getStageY(e.getY()));
				mouseInfo.setSource(stage);
				simManager.insertEventObject(new MouseDraggedObject(stage,
						mouseInfo));
			}
		}
	}

	public void mouseEntered(MouseEvent e) {
		// siehe mouseMoved
	}

	public void mouseExited(MouseEvent e) {
		// siehe mouseMoved
	}

	public void mouseMoved(MouseEvent e) {
		try {
			SimulationManager simManager = SimulationManager
					.getSimulationManager();
			this.stagePanel = Play.getPlay().getStagePanel();
			// this.stagePanel.requestFocusInWindow();
			this.iStage = Play.getPlay().getActiveStage();
			this.calcConcernedObjects(e);
			List<Object> nowMovedObjects = new ArrayList<Object>();

			MouseInfo mouseInfo = new MouseInfo(e);
			mouseInfo.setColumn(this.stagePanel.getCellColumn(e.getX()));
			mouseInfo.setRow(this.stagePanel.getCellRow(e.getY()));
			for (Object obj : this.concernedObjects) {
				if (Utils.dynInstanceof(obj, IComponent.class)) {
					IComponent iComp = (IComponent) obj;
					Component comp = IComponent.getComp(iComp);
					java.awt.Rectangle rect = this.stagePanel
							.getStageRectangle(iComp);
					mouseInfo
							.setX(this.stagePanel.getStageX(e.getX()) - rect.x);
					mouseInfo
							.setY(this.stagePanel.getStageY(e.getY()) - rect.y);
					mouseInfo.setSource(comp);
					if (this.movedObjects.contains(comp)) {
						nowMovedObjects.add(comp);
						simManager.insertEventObject(new MouseMovedObject(comp,
								mouseInfo));
					} else {
						nowMovedObjects.add(comp);
						simManager.insertEventObject(new MouseEnteredObject(
								comp, mouseInfo));
					}
				} else if (Utils.dynInstanceof(obj, IStage.class)) {
					IStage iStage = (IStage) obj;
					Stage stage = IStage.getStage(iStage);
					mouseInfo.setX(this.stagePanel.getStageX(e.getX()));
					mouseInfo.setY(this.stagePanel.getStageY(e.getY()));
					mouseInfo.setSource(stage);
					if (this.movedObjects.contains(stage)) {
						nowMovedObjects.add(stage);
						simManager.insertEventObject(new MouseMovedObject(
								stage, mouseInfo));
					} else {
						nowMovedObjects.add(stage);
						simManager.insertEventObject(new MouseEnteredObject(
								stage, mouseInfo));
					}
				}

			}

			// handle mouseExited
			// Anmerkung: kann bei sich bewegenden Akteure fehlschlagen
			// :-(
			IStage iStage = Play.getPlay().getActiveStage();
			List<IComponent> iComps = iStage.getComponentsInPaintOrder();
			for (int i = iComps.size() - 1; i >= 0; i--) {
				IComponent iComp = iComps.get(i);
				Component comp = IComponent.getComp(iComp);
				if (this.movedObjects.contains(comp)
						&& !nowMovedObjects.contains(comp)) {
					java.awt.Rectangle rect = this.stagePanel
							.getStageRectangle(iComp);
					mouseInfo
							.setX(this.stagePanel.getStageX(e.getX()) - rect.x);
					mouseInfo
							.setY(this.stagePanel.getStageY(e.getY()) - rect.y);
					mouseInfo.setSource(comp);
					simManager.insertEventObject(new MouseExitedObject(comp,
							mouseInfo));
				}
			}

			Stage stage = IStage.getStage(iStage);
			if (this.movedObjects.contains(stage)
					&& !nowMovedObjects.contains(stage)) {
				mouseInfo.setX(this.stagePanel.getStageX(e.getX()));
				mouseInfo.setY(this.stagePanel.getStageY(e.getY()));
				mouseInfo.setSource(stage);
				simManager.insertEventObject(new MouseExitedObject(stage,
						mouseInfo));
			}
			this.movedObjects = nowMovedObjects;
		} catch (Throwable th) {
			if (!Play.getPlay().isSimulator()) {
				th.printStackTrace();
			}
		}
	}

	private void calcConcernedObjects(MouseEvent e) {
		this.concernedObjects = new ArrayList<Object>();
		int stageX = this.stagePanel.getStageX(e.getX());
		int stageY = this.stagePanel.getStageY(e.getY());
		List<IComponent> iComps = this.iStage.getComponentsInPaintOrder();
		for (int i = iComps.size() - 1; i >= 0; i--) {
			IComponent iComp = iComps.get(i);
			if (iComp.isHandlingMouseEvents()) {
				java.awt.Rectangle rect = this.stagePanel
						.getStageRectangle(iComp);
				if (rect.contains(new java.awt.Point(stageX, stageY))) {
					this.concernedObjects.add(iComp);
				}
			}
		}
		if (this.iStage.isHandlingMouseEvents()) {
			int cellSize = this.iStage.getCellSize();
			java.awt.Rectangle stageRect = new java.awt.Rectangle(0, 0,
					this.iStage.getNumberOfColumns() * cellSize, this.iStage
							.getNumberOfRows()
							* cellSize);
			if (stageRect.contains(new java.awt.Point(stageX, stageY))) {
				this.concernedObjects.add(this.iStage);
			}
		}

	}
}
