package simulation.listener;

import theater.Component;
import theater.MouseInfo;
import theater.Stage;

public class MouseReleasedObject extends EventObject {

	public MouseReleasedObject(Component comp, MouseInfo mouseInfo) {
		super(comp, mouseInfo);
	}

	public MouseReleasedObject(Stage stage, MouseInfo mouseInfo) {
		super(stage, mouseInfo);
	}

	public void call() {
		MouseInfo eventInfo = (MouseInfo) this.eventInfo;
		if (comp != null) {
			if (comp.isHandlingMouseEvents() && !eventInfo.isConsumed()) {
				comp.mouseReleased(eventInfo);
			}
		} else {
			if (stage.isHandlingMouseEvents() && !eventInfo.isConsumed()) {
				stage.mouseReleased(eventInfo);
			}
		}
	}
}
