package simulation.listener;

import theater.Component;
import theater.MouseInfo;
import theater.Stage;

public class MouseClickedObject extends EventObject {

	public MouseClickedObject(Component comp, MouseInfo mouseInfo) {
		super(comp, mouseInfo);
	}

	public MouseClickedObject(Stage stage, MouseInfo mouseInfo) {
		super(stage, mouseInfo);
	}

	public void call() {
		MouseInfo eventInfo = (MouseInfo) this.eventInfo;
		if (comp != null) {
			if (comp.isHandlingMouseEvents() && !eventInfo.isConsumed()) {
				comp.mouseClicked(eventInfo);
			}
		} else {
			if (stage.isHandlingMouseEvents() && !eventInfo.isConsumed()) {
				stage.mouseClicked(eventInfo);
			}
		}
	}
}
