package simulation.listener;

import theater.Component;
import theater.KeyInfo;
import theater.Stage;

public class KeyTypedObject extends EventObject {

	public KeyTypedObject(Component comp, KeyInfo keyInfo) {
		super(comp, keyInfo);
	}

	public KeyTypedObject(Stage stage, KeyInfo keyInfo) {
		super(stage, keyInfo);
	}

	public void call() {
		KeyInfo eventInfo = (KeyInfo)this.eventInfo;
		if (comp != null) {
			if (comp.isHandlingKeyEvents() && !eventInfo.isConsumed()) {
				comp.keyTyped(eventInfo);
			}
		} else {
			if (stage.isHandlingKeyEvents() && !eventInfo.isConsumed()) {
				stage.keyTyped(eventInfo);
			}
		}
	}
}
