package scratch.elements.voids;

import java.util.ArrayList;

import scratch.Renderable;
import scratch.ScratchProgram;
import scratch.elements.ReturnObject;



public class ReturnBooleanObject extends ReturnObject {
	public ReturnBooleanObject() {
		super(getParameter());
		next = null;
		nextDock = null;
	}
	
	private static ArrayList<Type> getParameter() {
		ArrayList<Type> parameter = new ArrayList<Type>();
		parameter.add(Type.BOOLEAN);
		return parameter;
	}
	
	@Override
	public String getName() {
		return "returnB";
	}
	
	@Override
	public Renderable clone() {
		return new ReturnBooleanObject();
	}

	@Override
	public Object performImplementation(ScratchProgram program) throws FunctionResultException, ExitProgramException {
		boolean bool = true;
		if (childs.get(0) != null)
			bool = (Boolean)childs.get(0).perform(program);
		
		throw new FunctionResultException(bool);
	}
}
