package scratch.elements.voids;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

import scratch.Renderable.Type;
import scratch.elements.VoidObject;
import theater.Component;
import theater_intern.IComponent;
import view.ComponentPopupMenu;
import view.MethodComparator;

public class DynVoidObjects extends ArrayList<VoidObjectMethod> {

	protected DynVoidObjects() {
		super();
	}

	private static DynVoidObjects obj = null;

	public static DynVoidObjects getObject() {
		if (obj == null) {
			obj = new DynVoidObjects();
		}
		return obj;
	}

	public void addVoidObject(String name, Method m) {
		VoidObject obj = new VoidObject(name, new ArrayList<Type>());
		add(new VoidObjectMethod(obj, m));
	}
	
	public boolean containsElement(String name) {
		for (VoidObjectMethod om : this) {
			if (om.obj.getName().equals(name)) {
				return true;
			}
		}
		return false;
	}

	public VoidObject getVoidObject(String name) {
		for (VoidObjectMethod om : this) {
			if (om.obj.getName().equals(name)) {
				return om.obj;
			}
		}
		return null;
	}
	
	public boolean containsVoidObject(Method method) {
		for (VoidObjectMethod om : this) {
			if (om.method == method) {
				return true;
			}
		}
		return false;
	}
	

	public Method getMethod(String name) {
		for (VoidObjectMethod om : this) {
			if (om.obj.getName().equals(name)) {
				return om.method;
			}
		}
		return null;
	}

	public ArrayList<VoidObject> getVoidObjects() {
		ArrayList<VoidObject> res = new ArrayList<VoidObject>();
		for (VoidObjectMethod om : this) {
			res.add(om.obj);
		}
		return res;
	}

	public ArrayList<String> getNames() {
		ArrayList<String> res = new ArrayList<String>();
		for (VoidObjectMethod om : this) {
			res.add(om.obj.getName());
		}
		return res;
	}

	public void fill(IComponent icomp) {
		this.clear();
		MethodComparator comparator = new MethodComparator();
		Component comp = IComponent.getComp(icomp);
		Class<?> cls = comp.getClass();
		cls = cls.getSuperclass();
		Method[] methods = ComponentPopupMenu.getScratchVoidMethods(comp, cls);
		Arrays.sort(methods, comparator);
		for (Method method : methods) {
			String name = ComponentPopupMenu.genScratchMethodName(method);
			addVoidObject(name, method);
		}
	}

}

class VoidObjectMethod {
	VoidObject obj;
	Method method;

	VoidObjectMethod(VoidObject o, Method m) {
		this.obj = o;
		this.method = m;
	}
}
