package scratch;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

import javax.swing.JFrame;

import model.Play;
import scratch.Renderable.Type;
import scratch.elements.BooleanMethodObject;
import scratch.elements.VoidObject;
import scratch.elements.booleans.AndBooleanObject;
import scratch.elements.booleans.DynBooleanObjects;
import scratch.elements.booleans.FalseBooleanObject;
import scratch.elements.booleans.NotBooleanObject;
import scratch.elements.booleans.OrBooleanObject;
import scratch.elements.booleans.TrueBooleanObject;
import scratch.elements.controls.DoWhileObject;
import scratch.elements.controls.IfElseObject;
import scratch.elements.controls.IfObject;
import scratch.elements.controls.WhileObject;
import scratch.elements.voids.DynVoidObjects;
import scratch.elements.voids.ReturnBooleanObject;
import scratch.elements.voids.ReturnVoidObject;
import scratch.gui.InvalidIdentifierException;
import util.ResourceLoader;

/**
 * Die ScratchUtils bieten einige nütliche statische Funktionen, so dass der
 * Sourcecode minimiert wird.
 * 
 * @author HackZ
 * 
 */
public class ScratchUtils {
	/**
	 * Lädt die Ressource als Bild von der übergebenen Position <tt>name</tt>.
	 * 
	 * @param name
	 *            Lokale Refferenz zu der Ressource.
	 * @return
	 */
	public static BufferedImage getImage(String name) {
		Image img = ResourceLoader.getImageIcon(name).getImage(); // dibo
		BufferedImage buffImg = new BufferedImage(img.getWidth(null), img
				.getHeight(null), BufferedImage.TYPE_INT_ARGB);
		Graphics g = buffImg.getGraphics();
		g.drawImage(img, 0, 0, null);
		return buffImg;
	}

	/**
	 * Liefert die Breite zu dem übergebenen Text mit der übergebenen
	 * Schriftart.
	 * 
	 * @param text
	 *            Text zu dem die Breite geprüft werden soll.
	 * @param font
	 *            Schriftart, mit der der Text geschrieben wird.
	 * @return Breite in Pixeln.
	 */
	public static int getTextWidth(String text, Font font) {
		BufferedImage temp = new BufferedImage(1, 1, BufferedImage.TYPE_INT_RGB);
		Graphics g = temp.getGraphics();
		FontMetrics metrics = g.getFontMetrics(font);
		return metrics.stringWidth(text);
	}

	/**
	 * Liefert die Höhe zu dem übergebenen Text mit der übergebenen Schriftart.
	 * 
	 * @param text
	 *            Text zu dem die Höhe geprüft werden soll.
	 * @param font
	 *            Schriftart, mit der der Text geschrieben wird.
	 * @return Höhe in Pixeln.
	 */
	public static int getTextHeight(String text, Font font) {
		BufferedImage temp = new BufferedImage(1, 1, BufferedImage.TYPE_INT_RGB);
		Graphics g = temp.getGraphics();
		FontMetrics metrics = g.getFontMetrics(font);
		return metrics.getHeight();
	}

	/**
	 * Liefert das WorkbenchFrame des HamsterSimulators.
	 * 
	 * @return
	 */
	public static JFrame getWorkbenchFrame() {
		return Play.getPlay().getPlayFrame(); // dibo
		// return Workbench.getWorkbench().getView().getEditorFrame();
	}

	/**
	 * Überprüft, ob der übergebene text allen Javaidentifier Konventionen
	 * entspricht.
	 * 
	 * @param text
	 *            text, der geprüft wird.
	 * @throws InvalidIdentifierException
	 *             Wird geworfen, falls der Bezeichner nicht den
	 *             Javakonventionen entspricht.
	 */
	public static void checkJavaIdentifier(String text)
			throws InvalidIdentifierException {
		if (text.equals("")) {
			throw new InvalidIdentifierException(
					"Der Bezeichner darf nicht leer sein!");
		}

		// if (!ScratchUtils.isIdentifierChar(text.charAt(0))) {
		// throw new InvalidIdentifierException(
		// "Der Bezeichner muss mit einem Buchstaben, Dollarzeichen oder Unterstrich beginnen!");
		// }

		for (int i = 0; i < text.length(); i++) {
			if (!(ScratchUtils.isIdentifierChar(text.charAt(i)) || ScratchUtils
					.isNumeric(text.charAt(i)))) {
				throw new InvalidIdentifierException(
						"Der Bezeichner enthält unzulässige Zeichen!");
			}
		}
	}

	/**
	 * Überprüft, ob der Buchtabe in einem Javaidentifier vorkommen darf
	 * 
	 * @param c
	 *            Zu prüfender Buchstabe.
	 * @return true, wenn der Buchtabe verwendet werden darf.
	 */
//	public static boolean isIdentifierChar(char c) {
//		switch (c) {
//		case '$':
//		case '_':
//		case ' ':
//		case '!':
//		case '?':
//		case 'ä':
//		case 'ö':
//		case 'ü':
//		case 'Ä':
//		case 'Ö':
//		case 'Ü':
//		case 'ß':
//		case '+':
//		case '-':
//		case '*':
//		case '/':
//			return true;
//		}
//
//		if (c >= 'a' && c <= 'z') {
//			return true;
//		}
//
//		if (c >= 'A' && c <= 'Z') {
//			return true;
//		}
//
//		return false;
//	}
	
	public static boolean isIdentifierChar(char c) {
		switch (c) {
		case '$':
		case '_':
		case ' ':
		case '!':
		case '?':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '+':
		case '-':
		case '*':
		case '/':
			return true;
		}

		if (c >= 'a' && c <= 'z') {
			return true;
		}

		if (c >= 'A' && c <= 'Z') {
			return true;
		}

		return false;
	}
	
	

	/**
	 * Überprüft, ob der Character numerisch ist
	 * 
	 * @param c
	 *            Zu prüfender Character
	 * @return true, wenn der Character numerisch ist (0-9).
	 */
	public static boolean isNumeric(char c) {
		if (c >= '0' && c <= '9') {
			return true;
		}

		return false;
	}

	/**
	 * Erstellt ein Redenerable, das dem übergebenen Namen entspricht und
	 * liefert diesen zurück.
	 * 
	 * @param name
	 *            Name des Renderables
	 * @param type
	 *            Typ des Renderables
	 * @return
	 */
	public static Renderable getRenderableByName(String name, String type) {
		// Feste voids
		VoidObject vObj = DynVoidObjects.getObject().getVoidObject(name);
		if (vObj != null) {
			return vObj.clone();
		}

		// if (name.equals("vor"))
		// return new VorVoidObject();
		//
		// if (name.equals("linksUm"))
		// return new LinksUmVoidObject();
		//
		// if (name.equals("nimm"))
		// return new NimmVoidObject();
		//
		// if (name.equals("gib"))
		// return new GibVoidObject();

		if (name.equals("return")) {
			return new ReturnVoidObject();
		}

		if (name.equals("returnB")) {
			return new ReturnBooleanObject();
		}

		// Feste booleans
		BooleanMethodObject bObj = DynBooleanObjects.getObject()
				.getBooleanObject(name);
		if (bObj != null) {
			return bObj.clone();
		}

		// if (name.equals("vornFrei"))
		// return new VornFreiBooleanObject();
		//
		// if (name.equals("kornDa"))
		// return new KornDaBooleanObject();
		//
		// if (name.equals("maulLeer"))
		// return new MaulLeerBooleanObject();

		if (name.equals("wahr")) {
			return new TrueBooleanObject();
		}

		if (name.equals("falsch")) {
			return new FalseBooleanObject();
		}

		if (name.equals("und")) {
			return new AndBooleanObject();
		}

		if (name.equals("oder")) {
			return new OrBooleanObject();
		}

		if (name.equals("nicht")) {
			return new NotBooleanObject();
		}

		// Controller
		if (name.equals("falls")) {
			return new IfObject();
		}

		if (name.equals("fallsSonst")) {
			return new IfElseObject();
		}

		if (name.equals("solange")) {
			return new WhileObject();
		}

		if (name.equals("tueSolange")) {
			return new DoWhileObject();
		}

		if (type.toUpperCase().equals("VOID")) {
			return new VoidObject(name, new ArrayList<Type>());
		} else {
			return new BooleanMethodObject(name, new ArrayList<Type>());
		}
	}

	public static Renderable getRenderableByName(String name, Type type) {
		switch (type) {
		case VOID:
			return ScratchUtils.getRenderableByName(name, "VOID");
		default:
			return ScratchUtils.getRenderableByName(name, "BOOLEAN");
		}
	}
}
