package model;

import java.util.Collection;
import java.util.HashMap;

/**
 * Verwaltet die Klassen eines Theaterstcks
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class ClassManager {

	private HashMap<String, TheaterClass> classes;
	private static ClassManager classManager = new ClassManager();

	/**
	 * Liefert den ClassManager
	 * 
	 * @return
	 */
	public static ClassManager getClassManager() {
		return classManager;
	}

	/**
	 * Fuegt eine neue Klasse hinzu
	 * 
	 * @param cls
	 */
	public void addClass(TheaterClass cls) {
		classes.put(cls.getName(), cls);
	}

	/**
	 * Entfernt eine Klasse; bergeben wird der Name
	 * 
	 * @param clsName
	 */
	public void removeClass(String clsName) {
		classes.remove(clsName);
	}

	/**
	 * Entfernt eine Klasse; bergeben wird die Klasse
	 * 
	 * @param cls
	 */
	public void removeClass(TheaterClass cls) {
		classes.remove(cls.getName());
	}

	/**
	 * Liefert die Klasse zu einem bestimmten Namen
	 * 
	 * @param name
	 * @return
	 */
	public TheaterClass getClass(String name) {
		return classes.get(name);
	}
	
	/**
	 * Liefert eine Liste mit allen Klassen des Theaterstcks
	 * @return
	 */
	public Collection<TheaterClass> getAllClasses() {
		return classes.values();
	}
	
	public boolean classExists(String name) {
		return classes.get(name) != null;
	}

	private ClassManager() {
		this.classes = new HashMap<String, TheaterClass>();
	}
}
