package model;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.util.Observable;
import java.util.Observer;

import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;

import listener.ActionButtonListener;
import listener.ActionButtonPopupListener;
import util.ResourceLoader;
import view.ActionButtonPopupMenu;
import view.NewPropButton;

import compiler.CompileManager;

public class ActionButton implements Observer {

	public static final String ACTION_HANDLER = "ActionHandler";
	public static final String NEWPROP_HANDLER = "NewPropHandler";
	public static final String CLICK_HANDLER = "ClickHandler";

	private String name;
	private String tooltip;
	private String iconFilename; // relativer Icon-Dateiname im Ordern images
	private ImageIcon icon;
	private String type;

	private AbstractButton jButton;
	private ActionButtonPopupMenu popup;
	private MouseListener popupListener;
	private ActionButtonListener actionButtonListener;

	private MouseAdapter clickListener = null;

	public static ButtonGroup group = new ButtonGroup();

	public ActionButton(String name, String type) {
		this.name = name;
		this.type = type;
		this.tooltip = name;
		this.iconFilename = null;
		this.icon = ResourceLoader.getImageIcon("Empty24.gif");
		if (type.equals(CLICK_HANDLER)) {
			this.jButton = new JToggleButton(this.icon);
			group.add(this.jButton);
		} else if (type.equals(NEWPROP_HANDLER)) {
			this.jButton = new NewPropButton(this.icon);
		} else {
			this.jButton = new JButton(this.icon);
		}

		this.jButton
				.addActionListener(actionButtonListener = new ActionButtonListener(
						this));
		this.popup = new ActionButtonPopupMenu(this);
		this.popupListener = new ActionButtonPopupListener(this, this.popup);
		if (!Play.getPlay().isSimulator()) {
			this.jButton.addMouseListener(popupListener);
		}
		CompileManager.getCompileManager().addObserver(this);
	}

	public ActionButton(String name, String type, String tooltip,
			String iconFileName) {
		this.name = name;
		this.type = type;
		if (tooltip != null) {
			this.tooltip = tooltip;
		} else {
			this.tooltip = name;
		}
		this.iconFilename = iconFileName;
		if (iconFileName == null) {
			this.icon = ResourceLoader.getImageIcon("Empty24.gif");
		} else {
			this.icon = new ImageIcon(Play.getPlay().getDirectory() + "/"
					+ "images" + "/" + this.iconFilename);
		}
		if (type.equals(CLICK_HANDLER)) {
			this.jButton = new JToggleButton(this.icon);
			group.add(this.jButton);
		} else if (type.equals(NEWPROP_HANDLER)) {
			this.jButton = new NewPropButton(this.icon);
		} else {
			this.jButton = new JButton(this.icon);
		}

		this.jButton
				.addActionListener(actionButtonListener = new ActionButtonListener(
						this));
		this.popup = new ActionButtonPopupMenu(this);
		this.popupListener = new ActionButtonPopupListener(this, this.popup);
		if (!Play.getPlay().isSimulator()) {
			this.jButton.addMouseListener(popupListener);
		}
		CompileManager.getCompileManager().addObserver(this);
	}

	public void delete() {
		if (this.jButton instanceof JToggleButton) {
			group.remove(this.jButton);
		}
		this.actionButtonListener.unselect();
		this.jButton.removeMouseListener(this.popupListener);
		CompileManager.getCompileManager().deleteObserver(this);
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return this.type;
	}

	public String getTooltip() {
		return this.tooltip;
	}

	public void setTooltip(String str) {
		this.tooltip = str;
		this.jButton.setToolTipText(str);
	}

	public String getIconFilename() {
		return this.iconFilename;
	}

	public void setIconFilename(String iconFilename) {
		this.iconFilename = iconFilename;
		this.icon = new ImageIcon(Play.getPlay().getDirectory() + "/"
				+ "images" + "/" + this.iconFilename);
		this.jButton.setIcon(this.icon);
	}

	public AbstractButton getJButton() {
		return this.jButton;
	}

	public void update(Observable o, Object arg) {
		if (CompileManager.getCompileManager().isCompilationRequired()) {
			this.actionButtonListener.unselect();
			this.jButton.setSelected(false);
			this.jButton.setEnabled(false);
		} else {
			this.jButton.setEnabled(true);
		}
		ActionButton.group.clearSelection();
		ActionButtonListener.unselectAll();
	}

	public void setClickListener(MouseAdapter l) {
		this.clickListener = l;
	}

	public MouseAdapter getClickListener() {
		return this.clickListener;
	}

	public ActionButtonListener getActionButtonListener() {
		return actionButtonListener;
	}

}
