package listener;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;

import model.Play;
import theater.Component;
import theater_intern.IComponent;
import util.ResourceManager;
import view.ComponentPopupMenu;

/**
 * Reagiert auf MouseEvents im Zustand stopped
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class StoppedMouseListener extends TheaterMouseListener {

	private IComponent activeComp;

	public StoppedMouseListener() {
		this.activeComp = null;
	}

	public void mouseDragged(MouseEvent e) {
		try {
			if (this.activeComp != null) {
				MouseInformation mouseInfo = new MouseInformation(e);
				if (this.activeComp.getColumn() != mouseInfo.getX()
						|| this.activeComp.getRow() != mouseInfo.getY()) {
					Component comp = IComponent.getComp(this.activeComp);
					comp.setLocation(mouseInfo.getX(), mouseInfo.getY());
				}
			}
		} catch (IllegalStateException exc) {
			// kann passieren, wenn nach dem Lschen noch gedragged wird
		}
	}

	public void mouseClicked(MouseEvent e) {
		this.maybeShowPopup(e);
	}

	public void mousePressed(MouseEvent e) {
		if (Play.getPlay().getActiveStage() == null) {
			return;
		}
		this.maybeShowPopup(e);
		if (e.getButton() == MouseEvent.BUTTON1) {
			MouseInformation mouseInfo = new MouseInformation(e);
			this.activeComp = StoppedMouseListener.getActor(mouseInfo);
		} else {
			this.activeComp = null;
		}
	}

	public void mouseReleased(MouseEvent e) {
		this.maybeShowPopup(e);
	}

	public static IComponent getActor(MouseInformation mouseInfo) {
		List<IComponent> comps = Play.getPlay().getActiveStage()
				.getComponentsInPaintOrder();
		int x = mouseInfo.getMouseEvent().getX();
		int y = mouseInfo.getMouseEvent().getY();
		for (int i = comps.size() - 1; i >= 0; i--) { // Paint order
			IComponent lComp = comps.get(i);
			Rectangle rect = Play.getPlay().getStagePanel().getRectangle(lComp);
			boolean contains = rect.contains(new Point(x, y));
			if (contains) {
				return lComp;
			}
		}
		return null;
	}

	private void maybeShowPopup(MouseEvent e) {
		if (Play.getPlay().getActiveStage() == null) {
			return;
		}
		if (e.isPopupTrigger()) {
			this.activeComp = null;
			MouseInformation mouseInfo = new MouseInformation(e);
			IComponent icomp = StoppedMouseListener.getActor(mouseInfo);
			mouseInfo.setComponent(icomp);
			if (icomp != null) {
				if (Play.getPlay().getActivePerformance().simulationRunning()) {
					Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
							ResourceManager.getResourceManager().getValue(
									"msg.nocompmenu"));
				} else {
					ComponentPopupMenu actorMenu = new ComponentPopupMenu(icomp);
					actorMenu.show(e.getComponent(), e.getX(), e.getY());
				}
			}
		}
	}
}
