package listener;

import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import model.Play;
import theater_intern.IPerformance;

/**
 * Listener zum ndern der Geschwindigkeit
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class SpeedListener implements ChangeListener {

	JSlider slider;

	public SpeedListener(JSlider slider) {
		this.slider = slider;
	}

	public void stateChanged(ChangeEvent e) {
		int value = this.slider.getValue();
		if (Play.getPlay().getActivePerformance() != null) {
			IPerformance.getPerformance(Play.getPlay().getActivePerformance())
					.setSpeed(value);
		}
		Play.getPlay().getStagePanel().setFocus();
	}

}
