package listener;

import java.io.File;
import java.io.IOException;

import javax.swing.JOptionPane;

import util.PropertyManager;
import util.ResourceManager;

public class SolistApplication {

	public static void main(String[] args) {
		if (Application.solistOption(args)) {
			Application.main(args);
			return;

		}
		String[] newArgs = new String[7 + args.length];
		try {
			// choose java
			String java = "java";
			String jdk = null;
			jdk = PropertyManager.getPropertyManager().getJDK();
			if (jdk != null) {
				java = jdk + File.separatorChar + "bin" + File.separatorChar
						+ "java";
			}

			newArgs[0] = java;
			newArgs[1] = PropertyManager.getPropertyManager()
					.getInitHeapSpace();
			newArgs[2] = PropertyManager.getPropertyManager().getMaxHeapSpace();
			newArgs[3] = "-splash:splashscreen.png";
			newArgs[4] = "-jar";
			newArgs[5] = Application.SOLIST_JAR_NAME;
			newArgs[6] = Application.SOLIST_OPTION;
			for (int i = 0; i < args.length; i++) {
				newArgs[7 + i] = args[i];
			}

			ProcessBuilder builder = new ProcessBuilder(newArgs);
			builder.start();
		} catch (IOException exc) {
			String msg = "";
			for (String s : newArgs) {
				msg = msg + s + " ";
			}
			JOptionPane.showMessageDialog(null, ResourceManager
					.getResourceManager().getValue("starterror")
					+ msg + ResourceManager
					.getResourceManager().getValue("starterror2"), ResourceManager.getResourceManager().getValue(
					"msg.error"), JOptionPane.ERROR_MESSAGE);
		}
	}
}
