package listener;

import java.io.File;
import java.io.IOException;

import javax.swing.JOptionPane;

import util.PropertyManager;
import util.ResourceManager;

public class SimulatorApplication {

	public static void main(String[] args) {
		if (Application.simulatorOption(args)) {
			if (!Application.eclipseOption(args)) {
				Application.main(new String[] { Application.SIMULATOR_OPTION,
						"-p", "-e", "data" });
			} else {
				Application.main(new String[] { Application.SIMULATOR_OPTION,
						"-eclipse", "-p", "-e", "data" });
			}
			return;

		}
		String[] newArgs = new String[7];
		try {
			// choose java
			String java = "java";
			String jdk = null;
			jdk = PropertyManager.getPropertyManager().getJDK();
			if (jdk != null) {
				java = jdk + File.separatorChar + "bin" + File.separatorChar
						+ "java";
			}

			newArgs[0] = java;
			newArgs[1] = PropertyManager.getPropertyManager()
					.getInitHeapSpace();
			newArgs[2] = PropertyManager.getPropertyManager().getMaxHeapSpace();
			newArgs[3] = "-splash:splashscreen.png";
			newArgs[4] = "-jar";
			newArgs[5] = Application.SIMULATOR_JAR_NAME;
			newArgs[6] = Application.SIMULATOR_OPTION;

			ProcessBuilder builder = new ProcessBuilder(newArgs);
			builder.start();
		} catch (IOException exc) {
			String msg = "";
			for (String s : newArgs) {
				msg = msg + s + " ";
			}
			JOptionPane.showMessageDialog(null, ResourceManager
					.getResourceManager().getValue("starterror")
					+ msg
					+ ResourceManager.getResourceManager().getValue(
							"starterror2"), ResourceManager
					.getResourceManager().getValue("msg.error"),
					JOptionPane.ERROR_MESSAGE);
		}
	}
}
