package listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import model.Play;
import theater.Component;
import theater.Performance;
import theater.Stage;
import util.ResourceManager;

public class SaveStageListener implements ActionListener {

	public void actionPerformed(ActionEvent e) {
		JFileChooser chooser = SaveProgramListener.getFileChooser();
		int returnVal = chooser.showSaveDialog(Play.getPlay().getPlayFrame());
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			File to = chooser.getSelectedFile();
			saveStage(to);
			Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.stage.saved"));
		} else {
			Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.actioncanceled"));
		}

	}

	public static void saveStage(File to) {

		try {

			FileOutputStream fs = new FileOutputStream(to);
			ObjectOutputStream os = new ObjectOutputStream(fs);

			Stage stage = Performance.getPerformance().getActiveStage();
			List<Component> components = stage.getComponents(); // inkl. Solist

			os.writeObject(stage);
			os.writeObject(components);

			os.close();
			Play.getPlay().getPlayFrame().setBackOK(true);
		} catch (IOException exc) {
			if (Play.getPlay().getPlayFrame().isBackOK()) {
				if (!Play.getPlay().isSimulator()) {
					JOptionPane.showMessageDialog(Play.getPlay()
							.getStagePanel(), exc.toString()
							+ "\n\n"
							+ ResourceManager.getResourceManager().getValue(
									"msg.notserializable"), exc.getClass()
							.getName(), JOptionPane.ERROR_MESSAGE);
				} else {
					JOptionPane.showMessageDialog(Play.getPlay()
							.getStagePanel(), exc.toString()
							+ "\n\n"
							+ ResourceManager.getResourceManager().getValue(
									"msg.notserializablesim"), exc.getClass()
							.getName(), JOptionPane.ERROR_MESSAGE);
				}
				Play.getPlay().getPlayFrame().setBackOK(false);
			}
		}
	}

}
