package listener;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;

import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

import util.ResourceManager;

import model.Play;

public class SaveStageAsPngListener implements ActionListener {

	public void actionPerformed(ActionEvent e) {
		JFileChooser chooser = SaveStageAsGifListener.getFileChooser();
		FileFilter filter = new PNGFilter();
		chooser.setFileFilter(filter);
		int returnVal = chooser.showSaveDialog(Play.getPlay().getPlayFrame());
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			try {
				File to = chooser.getSelectedFile();
				String fname = to.getAbsolutePath();
				if (!fname.toLowerCase().endsWith(".png")) {
					to = new File(fname + ".png");
				}
				Image im = Play.getPlay().getStagePanel().getStageImage();
				BufferedImage bim = new BufferedImage(im.getWidth(null), im
						.getHeight(null), BufferedImage.TYPE_INT_ARGB);
				Graphics g = bim.createGraphics();
				g.drawImage(im, 0, 0, null);
				ImageIO.write(bim, "png", to);
				Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.stage.pngsaved"));
			} catch (Throwable th) {
				th.printStackTrace();
			}
		} else {
			Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.actioncanceled"));
		}
	}
}

class PNGFilter extends FileFilter {

	public boolean accept(File f) {
		if (f.isDirectory()) {
			return true;
		}
		return f.getName().toLowerCase().endsWith(".png");
	}

	public String getDescription() {
		return "png";
	}

}
