package listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import model.Play;

import theater_intern.IComponent;
import theater_intern.IStage;
import util.ResourceManager;

/**
 * Listener fr das Lschen von Componenten
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class RemoveComponentListener implements ActionListener {

	private IComponent actor;

	public RemoveComponentListener(IComponent actor) {
		this.actor = actor;
	}

	public void actionPerformed(ActionEvent e) {
		IStage.getStage(this.actor.getStage()).remove(
				IComponent.getComp(this.actor));
		Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
				ResourceManager.getResourceManager().getValue("msg.removecomp"));
	}

}
