package listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;

import editor.SolistEditor;

import model.Play;
import util.IO;
import util.ResourceManager;
import view.PlayFrame;

public class ParadigmaListener implements ActionListener {

	PlayFrame frame;
	JCheckBoxMenuItem item;

	public ParadigmaListener(PlayFrame frame, JCheckBoxMenuItem item) {
		this.frame = frame;
		this.item = item;
	}

	public void actionPerformed(ActionEvent e) {
		int answer = JOptionPane.showConfirmDialog(frame, ResourceManager
				.getResourceManager().getValue("msg.paradigma.confirm"),
				ResourceManager.getResourceManager().getValue("msg.request"),
				JOptionPane.YES_NO_OPTION);
		if (answer == JOptionPane.YES_OPTION) {
			if (this.item.isSelected()) {
				IO.copyResTextFile(SolistEditor.CLASS_NAME + ".txt",
						SolistEditor.CLASS_NAME + ".txt");
				SolistEditor.getSolistEditor().getEditorPanel().loadFile(
						SolistEditor.CLASS_NAME + ".txt");
				SolistEditor.getSolistEditor().getEditor().setChanged(true);
				Play.getPlay().setParadigma(true);
				this.frame.getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.paradigma.imp"));
			} else {
				String classname = Play.getPlay().getActiveActorName();
				if (classname == null) {
					classname = "theater.Actor";
				}
				IO.copyResTextFile("OO" + SolistEditor.CLASS_NAME + ".txt",
						SolistEditor.CLASS_NAME + ".txt", classname);
				SolistEditor.getSolistEditor().getEditorPanel().loadFile(
						SolistEditor.CLASS_NAME + ".txt");
				SolistEditor.getSolistEditor().getEditor().setChanged(true);
				Play.getPlay().setParadigma(false);
				this.frame.getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.paradigma.oo"));
			}
		} else {
			this.item.setSelected(!this.item.isSelected());
		}

	}

}
